/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.List;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.AreaEffectCloudHelper;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class EntityAreaEffectCloud
implements Property {
    public static final String[] handledTags = new String[]{"base_potion", "particle", "duration", "radius", "reapplication_delay", "wait_time", "has_custom_effect", "source", "custom_effects"};
    public static final String[] handledMechs = new String[]{"clear_custom_effects", "remove_custom_effect", "custom_effects", "particle_color", "base_potion", "duration", "duration_on_use", "particle", "radius", "radius_on_use", "radius_per_tick", "reapplication_delay", "source", "wait_time"};
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntityType() == EntityType.AREA_EFFECT_CLOUD;
    }

    public static EntityAreaEffectCloud getFrom(dObject entity) {
        if (!EntityAreaEffectCloud.describes(entity)) {
            return null;
        }
        return new EntityAreaEffectCloud((dEntity)entity);
    }

    private EntityAreaEffectCloud(dEntity ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "area_effect_cloud";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        ProjectileSource shooter;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("base_potion")) {
            if ((attribute = attribute.fulfill(1)).startsWith("type")) {
                return new Element(this.getHelper().getBPName()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_upgraded")) {
                return new Element(this.getHelper().getBPUpgraded()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_extended")) {
                return new Element(this.getHelper().getBPExtended()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getHelper().getBPName() + "," + this.getHelper().getBPUpgraded() + "," + this.getHelper().getBPExtended()).getAttribute(attribute);
        }
        if (attribute.startsWith("particle")) {
            if ((attribute = attribute.fulfill(1)).startsWith("color")) {
                return new dColor(this.getHelper().getColor()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getHelper().getParticle()).getAttribute(attribute);
        }
        if (attribute.startsWith("duration")) {
            if ((attribute = attribute.fulfill(1)).startsWith("on_use")) {
                return new Duration(this.getHelper().getDurationOnUse()).getAttribute(attribute.fulfill(1));
            }
            return new Duration(this.getHelper().getDuration()).getAttribute(attribute);
        }
        if (attribute.startsWith("radius")) {
            if ((attribute = attribute.fulfill(1)).startsWith("on_use")) {
                return new Element(this.getHelper().getRadiusOnUse()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("per_tick")) {
                return new Element(this.getHelper().getRadiusPerTick()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getHelper().getRadius()).getAttribute(attribute);
        }
        if (attribute.startsWith("reapplication_delay")) {
            return new Duration(this.getHelper().getReappDelay()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("wait_time")) {
            return new Duration(this.getHelper().getWaitTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_custom_effect")) {
            if (attribute.hasContext(1)) {
                PotionEffectType effectType = PotionEffectType.getByName((String)attribute.getContext(1));
                for (PotionEffect effect : this.getHelper().getCustomEffects()) {
                    if (!effect.getType().equals((Object)effectType)) continue;
                    return new Element(true).getAttribute(attribute.fulfill(1));
                }
                return new Element(false).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getHelper().hasCustomEffects()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("source") && (shooter = this.getHelper().getSource()) != null && shooter instanceof LivingEntity) {
            return new dEntity((Entity)((LivingEntity)shooter)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("custom_effects")) {
            List<PotionEffect> effects = this.getHelper().getCustomEffects();
            if (!attribute.hasContext(1)) {
                dList list = new dList();
                for (PotionEffect effect : effects) {
                    list.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + new Duration((long)effect.getDuration()).identify() + "," + effect.isAmbient() + "," + effect.hasParticles());
                }
                return list.getAttribute(attribute.fulfill(1));
            }
            int val = attribute.getIntContext(1) - 1;
            if (val < 0 || val >= effects.size()) {
                return null;
            }
            attribute = attribute.fulfill(1);
            PotionEffect effect = effects.get(val);
            if (attribute.startsWith("type")) {
                return new Element(effect.getType().getName()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("amplifier")) {
                return new Element(effect.getAmplifier()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("duration")) {
                return new Duration((long)effect.getDuration()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("has_particles")) {
                return new Element(effect.hasParticles()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("is_ambient")) {
                return new Element(effect.isAmbient()).getAttribute(attribute.fulfill(1));
            }
            return new Element(effect.getType().getName() + "," + effect.getAmplifier() + "," + new Duration((long)effect.getDuration()).identify() + "," + effect.isAmbient() + "," + effect.hasParticles()).getAttribute(attribute);
        }
        return null;
    }

    public AreaEffectCloudHelper getHelper() {
        return new AreaEffectCloudHelper(this.entity.getBukkitEntity());
    }

    @Override
    public void adjust(Mechanism mechanism) {
        PotionEffectType type;
        if (mechanism.matches("clear_custom_effects")) {
            this.getHelper().clearEffects();
        }
        if (mechanism.matches("remove_custom_effect") && (type = PotionEffectType.getByName((String)mechanism.getValue().asString().toUpperCase())) != null) {
            this.getHelper().removeEffect(type);
        }
        if (mechanism.matches("custom_effects")) {
            dList list = mechanism.valueAsType(dList.class);
            this.getHelper().clearEffects();
            for (String item : list) {
                List<String> potionData = CoreUtilities.split(item, ',', 5);
                if (potionData.size() >= 3) {
                    PotionEffectType type2 = PotionEffectType.getByName((String)potionData.get(0));
                    Element amplifier = new Element(potionData.get(1));
                    Duration duration = Duration.valueOf(potionData.get(2));
                    Element ambient = new Element(potionData.size() > 3 ? potionData.get(3) : "false");
                    Element particles = new Element(potionData.size() > 4 ? potionData.get(4) : "true");
                    if (!(type2 != null && duration != null && amplifier.isInt() && ambient.isBoolean() && particles.isBoolean())) {
                        dB.echoError(item + " is not a valid potion effect!");
                        continue;
                    }
                    this.getHelper().addEffect(new PotionEffect(type2, duration.getTicksAsInt(), amplifier.asInt(), ambient.asBoolean(), particles.asBoolean()), true);
                    continue;
                }
                dB.echoError(item + " is not a valid potion effect!");
            }
        }
        if (mechanism.matches("particle_color") && mechanism.requireObject(dColor.class)) {
            this.getHelper().setColor(dColor.valueOf(mechanism.getValue().asString()).getColor());
        }
        if (mechanism.matches("base_potion")) {
            List<String> data = CoreUtilities.split(mechanism.getValue().asString().toUpperCase(), ',');
            if (data.size() != 3) {
                dB.echoError(mechanism.getValue().asString() + " is not a valid base potion!");
            } else {
                try {
                    boolean upgraded;
                    PotionType type3 = PotionType.valueOf((String)data.get(0));
                    boolean extended = type3.isExtendable() && CoreUtilities.toLowerCase(data.get(1)).equals("true");
                    boolean bl = upgraded = type3.isUpgradeable() && CoreUtilities.toLowerCase(data.get(2)).equals("true");
                    if (extended && upgraded) {
                        dB.echoError("Potion cannot be both upgraded and extended");
                    } else {
                        this.getHelper().setBP(type3, extended, upgraded);
                    }
                }
                catch (Exception e) {
                    dB.echoError(mechanism.getValue().asString() + " is not a valid base potion!");
                }
            }
        }
        if (mechanism.matches("duration") && mechanism.requireObject(Duration.class)) {
            this.getHelper().setDuration(Duration.valueOf(mechanism.getValue().asString()).getTicksAsInt());
        }
        if (mechanism.matches("duration_on_use") && mechanism.requireObject(Duration.class)) {
            this.getHelper().setDurationOnUse(Duration.valueOf(mechanism.getValue().asString()).getTicksAsInt());
        }
        if (mechanism.matches("particle") && mechanism.hasValue()) {
            this.getHelper().setParticle(mechanism.getValue().asString().toUpperCase());
        }
        if (mechanism.matches("radius") && mechanism.requireFloat()) {
            this.getHelper().setRadius(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("radius_on_use") && mechanism.requireFloat()) {
            this.getHelper().setRadiusOnUse(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("radius_per_tick") && mechanism.requireFloat()) {
            this.getHelper().setRadiusPerTick(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("reapplication_delay") && mechanism.requireObject(Duration.class)) {
            this.getHelper().setReappDelay(Duration.valueOf(mechanism.getValue().asString()).getTicksAsInt());
        }
        if (mechanism.matches("source") && mechanism.requireObject(dEntity.class)) {
            this.getHelper().setSource((ProjectileSource)dEntity.valueOf(mechanism.getValue().asString()).getBukkitEntity());
        }
        if (mechanism.matches("wait_time") && mechanism.requireObject(Duration.class)) {
            this.getHelper().setWaitTime(Duration.valueOf(mechanism.getValue().asString()).getTicksAsInt());
        }
    }
}

