/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ScribeCommand
extends AbstractCommand {
    @Override
    public void onEnable() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ScribeCommand.this.paragraph(event);
            }
        }, "p", "n");
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesEnum(BookAction.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", (Object)BookAction.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                scriptEntry.addObject("action", (Object)BookAction.DROP);
                continue;
            }
            if (!scriptEntry.hasObject("item") && arg.matchesArgumentType(dItem.class)) {
                scriptEntry.addObject("item", arg.asType(dItem.class));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("action", new Object[]{BookAction.GIVE});
        scriptEntry.defaultObject("item", new dItem(Material.WRITTEN_BOOK));
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Missing SCRIPT argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        BookAction action = (BookAction)((Object)scriptEntry.getObject("action"));
        dItem book = (dItem)scriptEntry.getObject("item");
        dScript script = (dScript)scriptEntry.getObject("script");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        BookScriptContainer bookScript = (BookScriptContainer)script.getContainer();
        book = bookScript.writeBookTo(book, ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), ((BukkitScriptEntryData)scriptEntry.entryData).getNPC());
        switch (action) {
            case DROP: {
                this.dropBook(location, book.getItemStack());
                break;
            }
            case GIVE: {
                this.giveBook(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity(), book.getItemStack());
                ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().updateInventory();
                break;
            }
            case EQUIP: {
                this.equipBook(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity(), book.getItemStack());
                ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().updateInventory();
                break;
            }
        }
    }

    private void giveBook(Player player, ItemStack book) {
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (emptySpot != -1) {
            player.getInventory().addItem(new ItemStack[]{book.clone()});
        } else {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.log("Player's inventory is full, dropped book.");
        }
    }

    private void equipBook(Player player, ItemStack book) {
        ItemStack currItem = player.getItemInHand();
        PlayerInventory inv = player.getInventory();
        int emptySpot = inv.firstEmpty();
        if (currItem == null || currItem.getType() == Material.AIR) {
            player.setItemInHand(book);
            return;
        }
        emptySpot = inv.firstEmpty();
        dB.log("emptySpot: " + emptySpot);
        if (emptySpot == -1) {
            player.getWorld().dropItem(player.getLocation(), book);
            dB.log("Player's inventory is full, dropped book.");
        } else {
            inv.setItem(emptySpot, currItem);
            player.setItemInHand(book);
            dB.log("...added book to player hand, moved original item");
        }
    }

    private void dropBook(Location location, ItemStack book) {
        location.getWorld().dropItem(location, book);
    }

    public void paragraph(ReplaceableTagEvent e) {
        if (e.matches("p")) {
            e.setReplaced("\n \u00a7r \n");
        } else if (e.matches("n")) {
            e.setReplaced("\n");
        }
    }

    private static enum BookAction {
        GIVE,
        DROP,
        EQUIP,
        NONE;

    }
}

