/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.Bukkit;

public class NarrateCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (scriptEntry.getArguments().size() > 4) {
            throw new InvalidArgumentsException("Too many arguments! Did you forget a 'quote'?");
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("format") && arg.matchesPrefix("format", "f")) {
                String formatStr = arg.getValue();
                FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(formatStr);
                if (format == null) {
                    dB.echoError("Could not find format script matching '" + formatStr + '\'');
                }
                scriptEntry.addObject("format", format);
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("target", "targets", "t")) {
                scriptEntry.addObject("targets", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("text")) {
                scriptEntry.addObject("text", new Element(TagManager.cleanOutputFully(arg.raw_value)));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets")) {
            scriptEntry.addObject("targets", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()) : null);
        }
        if (!scriptEntry.hasObject("text")) {
            throw new InvalidArgumentsException("Missing any text!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List targets = (List)scriptEntry.getObject("targets");
        String text = scriptEntry.getElement("text").asString();
        FormatScriptContainer format = (FormatScriptContainer)scriptEntry.getObject("format");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("Narrating", text) + aH.debugList("Targets", targets) + (format != null ? aH.debugObj("Format", format.getName()) : ""));
        }
        if (targets == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(format != null ? format.getFormattedText(scriptEntry) : text);
            return;
        }
        for (dPlayer player : targets) {
            if (player != null && player.isOnline()) {
                player.getPlayerEntity().sendMessage(format != null ? format.getFormattedText(scriptEntry) : text);
                continue;
            }
            dB.echoError("Narrated to non-existent or offline player!");
        }
    }
}

