/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.abstracts.Sidebar;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SidebarCommand
extends AbstractCommand {
    private static final Map<UUID, Sidebar> sidebars = new HashMap<UUID, Sidebar>();

    @Override
    public void onEnable() {
        this.setParseArgs(false);
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new SidebarEvents(), (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Action action = Action.SET;
        for (aH.Argument arg : aH.interpret(scriptEntry.getOriginalArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                action = Action.valueOf(arg.getValue().toUpperCase());
                continue;
            }
            if (!scriptEntry.hasObject("title") && arg.matchesPrefix("title", "t", "objective", "obj", "o")) {
                scriptEntry.addObject("title", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("lines") && arg.matchesPrefix("lines", "line", "l")) {
                scriptEntry.addObject("lines", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value") && arg.matchesPrefix("value", "values", "val", "v")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("increment") && arg.matchesPrefix("increment", "inc", "i")) {
                scriptEntry.addObject("increment", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("start") && arg.matchesPrefix("start", "s")) {
                scriptEntry.addObject("start", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesPrefix("players", "player", "p")) {
                scriptEntry.addObject("players", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("per_player") || !arg.matches("per_player")) continue;
            scriptEntry.addObject("per_player", new Element(true));
        }
        if (action == Action.ADD && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) for that action!");
        }
        if (!(action != Action.SET || scriptEntry.hasObject("value") || scriptEntry.hasObject("title") || scriptEntry.hasObject("increment") || scriptEntry.hasObject("start"))) {
            throw new InvalidArgumentsException("Must specify at least one of: value(s), title, increment, or start for that action!");
        }
        if (action == Action.SET && scriptEntry.hasObject("lines") && !scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify value(s) when setting lines!");
        }
        scriptEntry.addObject("action", new Element(action.name()));
        BukkitScriptEntryData entryData = (BukkitScriptEntryData)scriptEntry.entryData;
        scriptEntry.defaultObject("per_player", new Element(false)).defaultObject("players", new Element(entryData.hasPlayer() ? entryData.getPlayer().identify() : "li@"));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(ScriptEntry scriptEntry) {
        action = scriptEntry.getElement("action");
        elTitle = scriptEntry.getElement("title");
        elLines = scriptEntry.getElement("lines");
        elValue = scriptEntry.getElement("value");
        elIncrement = scriptEntry.getElement("increment");
        elStart = scriptEntry.getElement("start");
        elPlayers = scriptEntry.getElement("players");
        elPerPlayer = scriptEntry.getElement("per_player");
        players = dList.valueOf(TagManager.tag(elPlayers.asString(), new BukkitTagContext(scriptEntry, false)));
        per_player = elPerPlayer.asBoolean();
        perTitle = null;
        perLines = null;
        perValue = null;
        perIncrement = null;
        perStart = null;
        title = null;
        lines = null;
        value = null;
        increment = null;
        start = null;
        if (per_player) {
            if (elTitle != null) {
                perTitle = elTitle.asString();
            }
            if (elLines != null) {
                perLines = elLines.asString();
            }
            if (elValue != null) {
                perValue = elValue.asString();
            }
            if (elIncrement != null) {
                perIncrement = elIncrement.asString();
            }
            if (elStart != null) {
                perStart = elStart.asString();
            }
            debug = action.debug() + (elTitle != null ? elTitle.debug() : "") + (elLines != null ? elLines.debug() : "") + (elValue != null ? elValue.debug() : "") + (elIncrement != null ? elIncrement.debug() : "") + (elStart != null ? elStart.debug() : "") + players.debug();
        } else {
            context = (BukkitTagContext)DenizenAPI.getCurrentInstance().getTagContextFor(scriptEntry, false);
            if (elTitle != null) {
                title = new Element(TagManager.tag(elTitle.asString(), context));
            }
            if (elLines != null) {
                lines = dList.valueOf(TagManager.tag(elLines.asString(), context));
            }
            if (elValue != null) {
                value = dList.valueOf(TagManager.tag(elValue.asString(), context));
            }
            if (elIncrement != null) {
                increment = new Element(TagManager.tag(elIncrement.asString(), context));
            }
            if (elStart != null) {
                start = new Element(TagManager.tag(elStart.asString(), context));
            }
            debug = action.debug() + (title != null ? title.debug() : "") + (lines != null ? lines.debug() : "") + (value != null ? value.debug() : "") + (increment != null ? increment.debug() : "") + (start != null ? start.debug() : "") + players.debug();
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), debug);
        }
        switch (1.$SwitchMap$net$aufdemrand$denizen$scripts$commands$player$SidebarCommand$Action[Action.valueOf(action.asString()).ordinal()]) {
            case 1: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        value = dList.valueOf(TagManager.tag(perValue, context));
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                    }
                    if (lines == null) ** GOTO lbl73
                    try {
                        for (i = 0; i < lines.size(); ++i) {
                            index = Integer.valueOf((String)lines.get(i)) - 1;
                            line = (String)value.get(i);
                            current.add(index, line);
                        }
                        ** GOTO lbl75
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                        continue;
                    }
lbl73:
                    // 1 sources

                    current.addAll(value);
lbl75:
                    // 2 sources

                    sidebar.setLines(current);
                    sidebar.sendUpdate();
                }
                break;
            }
            case 2: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                    }
                    if (lines != null) {
                        try {
                            offset = 0;
                            for (Object line : lines) {
                                index = Integer.valueOf((String)line) - 1 - offset;
                                current.remove(index);
                                ++offset;
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        continue;
                    }
                    if (value != null) {
                        try {
                            it = current.iterator();
                            while (it.hasNext()) {
                                next = it.next();
                                line = value.iterator();
                                while (line.hasNext()) {
                                    line = (String)line.next();
                                    if (!next.equalsIgnoreCase(line)) continue;
                                    it.remove();
                                }
                            }
                            for (Object line : value) {
                                for (i = 0; i < current.size(); ++i) {
                                    if (!current.get(i).equalsIgnoreCase((String)line)) continue;
                                    current.remove(i--);
                                }
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        sidebar.setLines(current);
                        sidebar.sendUpdate();
                        continue;
                    }
                    sidebar.remove();
                    SidebarCommand.sidebars.remove(player.getPlayerEntity().getUniqueId());
                }
                break;
            }
            case 3: {
                for (dPlayer player : players.filter(dPlayer.class, scriptEntry)) {
                    if (player == null || !player.isValid()) {
                        dB.echoError("Invalid player!");
                        continue;
                    }
                    sidebar = SidebarCommand.createSidebar(player);
                    if (sidebar == null) continue;
                    current = sidebar.getLines();
                    currEdited = false;
                    if (per_player) {
                        context = new BukkitTagContext(player, ((BukkitScriptEntryData)scriptEntry.entryData).getNPC(), false, scriptEntry, scriptEntry.shouldDebug(), scriptEntry.getScript());
                        if (perValue != null) {
                            value = dList.valueOf(TagManager.tag(perValue, context));
                        }
                        if (perLines != null) {
                            lines = dList.valueOf(TagManager.tag(perLines, context));
                        }
                        if (perStart != null) {
                            start = new Element(TagManager.tag(perStart, context));
                        }
                        if (perIncrement != null) {
                            increment = new Element(TagManager.tag(perIncrement, context));
                        }
                        if (perTitle != null) {
                            title = new Element(TagManager.tag(perTitle, context));
                        }
                    }
                    if (lines != null) {
                        try {
                            for (i = 0; i < lines.size(); ++i) {
                                index = Integer.valueOf((String)lines.get(i)) - 1;
                                line = (String)value.get(i);
                                if (index > current.size()) {
                                    current.add(line);
                                    continue;
                                }
                                current.set(index, line);
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                            continue;
                        }
                        currEdited = true;
                    } else if (value != null) {
                        current = value;
                        currEdited = true;
                    }
                    if (start != null) {
                        sidebar.setStart(start.asInt());
                        currEdited = true;
                    }
                    if (increment != null) {
                        sidebar.setIncrement(increment.asInt());
                        currEdited = true;
                    }
                    if (title != null) {
                        sidebar.setTitle(title.asString());
                    }
                    if (currEdited) {
                        sidebar.setLines(current);
                    }
                    sidebar.sendUpdate();
                }
                break;
            }
        }
    }

    private static Sidebar createSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        Player player = denizenPlayer.getPlayerEntity();
        UUID uuid = player.getUniqueId();
        if (!sidebars.containsKey(uuid)) {
            sidebars.put(uuid, NMSHandler.getInstance().createSidebar(player));
        }
        return sidebars.get(player.getUniqueId());
    }

    public static Sidebar getSidebar(dPlayer denizenPlayer) {
        if (!denizenPlayer.isOnline()) {
            return null;
        }
        return sidebars.get(denizenPlayer.getPlayerEntity().getUniqueId());
    }

    public static class SidebarEvents
    implements Listener {
        @EventHandler
        public void onPlayerQuit(PlayerQuitEvent event) {
            UUID uuid = event.getPlayer().getUniqueId();
            if (sidebars.containsKey(uuid)) {
                sidebars.remove(uuid);
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }
}

