/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import java.util.Collection;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.SlowWarning;

public class QueueTags {
    public SlowWarning queueShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'queue' instead of 'q' as a root tag.");

    public QueueTags() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                QueueTags.this.queueTag(event);
            }
        }, "queue", "q");
    }

    public void queueTag(ReplaceableTagEvent event) {
        if (!event.matches("queue", "q")) {
            return;
        }
        if (event.matches("q")) {
            this.queueShorthand.warn(event.getScriptEntry());
        }
        if (event.hasNameContext()) {
            if (!ScriptQueue._queueExists(event.getNameContext())) {
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(ScriptQueue._getExistingQueue(event.getNameContext()), event.getAttributes().fulfill(1)));
            return;
        }
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("exists") && attribute.hasContext(1)) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new Element(ScriptQueue._queueExists(attribute.getContext(1))), attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("stats")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new Element(ScriptQueue._getStats()), attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("list")) {
            event.setReplacedObject(CoreUtilities.autoAttrib(new dList((Collection<? extends dObject>)ScriptQueue._getQueues()), attribute.fulfill(1)));
            return;
        }
        event.setReplacedObject(CoreUtilities.autoAttrib(event.getScriptEntry().getResidingQueue(), attribute));
    }
}

