/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.abstracts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.nms.NMSHandler;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class BlockLight {
    protected static final Map<Location, BlockLight> lightsByLocation = new HashMap<Location, BlockLight>();
    protected static final Map<Chunk, List<BlockLight>> lightsByChunk = new HashMap<Chunk, List<BlockLight>>();
    protected static final BlockFace[] adjacentFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};
    protected final Block block;
    public final Chunk chunk;
    protected final int originalLight;
    protected int currentLight;
    public int cachedLight;
    public BukkitTask removeTask;

    protected BlockLight(Location location, long ticks) {
        this.block = location.getBlock();
        this.chunk = location.getChunk();
        this.currentLight = this.originalLight = (int)this.block.getLightLevel();
        this.cachedLight = this.originalLight;
        this.removeLater(ticks);
    }

    public void removeLater(long ticks) {
        if (ticks > 0L) {
            this.removeTask = new BukkitRunnable(){

                public void run() {
                    BlockLight.this.removeTask = null;
                    BlockLight.removeLight(BlockLight.this.block.getLocation());
                }
            }.runTaskLater((Plugin)NMSHandler.getJavaPlugin(), ticks);
        }
    }

    public static void removeLight(Location location) {
        if (lightsByLocation.containsKey(location = location.getBlock().getLocation())) {
            BlockLight blockLight = lightsByLocation.get(location);
            blockLight.reset(true);
            if (blockLight.removeTask != null) {
                blockLight.removeTask.cancel();
            }
            lightsByLocation.remove(location);
            lightsByChunk.get(blockLight.chunk).remove(blockLight);
            if (lightsByChunk.get(blockLight.chunk).isEmpty()) {
                lightsByChunk.remove(blockLight.chunk);
            }
        }
    }

    public void reset(boolean updateChunk) {
        this.update(this.originalLight, updateChunk);
    }

    public abstract void update(int var1, boolean var2);
}

