/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;

public class EntityChangesBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityChangesBlockScriptEvent instance;
    public dEntity entity;
    public dLocation location;
    public dMaterial old_material;
    public dMaterial new_material;
    public dList cuboids;
    public EntityChangeBlockEvent event;

    public EntityChangesBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "changes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        String entName = CoreUtilities.getXthArg(0, lower);
        if (!this.tryEntity(this.entity, entName)) {
            return false;
        }
        if (!this.tryMaterial(this.old_material, CoreUtilities.getXthArg(2, lower))) {
            return false;
        }
        if (CoreUtilities.xthArgEquals(3, lower, "into")) {
            String mat2 = CoreUtilities.getXthArg(4, lower);
            if (mat2.isEmpty()) {
                dB.echoError("Invalid event material [" + this.getName() + "]: '" + path.event + "' for " + path.container.getName());
                return false;
            }
            if (!this.tryMaterial(this.new_material, mat2)) {
                return false;
            }
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "EntityChangesBlock";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("cuboids")) {
            if (this.cuboids == null) {
                this.cuboids = new dList();
                for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                    this.cuboids.add(cuboid.identifySimple());
                }
            }
            return this.cuboids;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("new_material")) {
            return this.new_material;
        }
        if (name.equals("old_material")) {
            return this.old_material;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityChangesBlock(EntityChangeBlockEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.location = new dLocation(event.getBlock().getLocation());
        this.old_material = new dMaterial(this.location.getBlock());
        this.new_material = new dMaterial(event.getTo());
        this.cuboids = null;
        this.event = event;
        this.fire((Cancellable)event);
    }
}

