/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public class VehicleDestroyedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static VehicleDestroyedScriptEvent instance;
    public dEntity vehicle;
    public dEntity entity;
    public VehicleDestroyEvent event;

    public VehicleDestroyedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("destroyed") || cmd.equals("destroys");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String ent;
        String lower = path.eventLower;
        String cmd = CoreUtilities.getXthArg(1, lower);
        String veh = cmd.equals("destroyed") ? CoreUtilities.getXthArg(0, lower) : CoreUtilities.getXthArg(2, lower);
        String string = ent = cmd.equals("destroys") ? CoreUtilities.getXthArg(0, lower) : "";
        if (!this.tryEntity(this.vehicle, veh)) {
            return false;
        }
        if (!(ent.length() <= 0 || this.entity != null && this.tryEntity(this.entity, ent))) {
            return false;
        }
        return this.runInCheck(path, this.vehicle.getLocation());
    }

    @Override
    public String getName() {
        return "VehicleDestroyed";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        if (this.entity != null) {
            return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
        }
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onVehicleDestroyed(VehicleDestroyEvent event) {
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.entity = event.getAttacker() != null ? new dEntity(event.getAttacker()) : null;
        this.event = event;
        this.fire((Cancellable)event);
    }
}

