/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerEquipsArmorScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerEquipsArmorScriptEvent instance;
    public Element equipType;
    public Element armorType;
    public Element reason;
    public dItem armor;
    public dPlayer player;

    public PlayerEquipsArmorScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player equips ") || lower.startsWith("player unequips ");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String lower = path.eventLower;
        String type = CoreUtilities.getXthArg(1, lower);
        if (!type.equals(CoreUtilities.toLowerCase(this.equipType.asString()))) {
            return false;
        }
        String eItem = CoreUtilities.getXthArg(2, lower);
        return eItem.equals("armor") || eItem.equals(CoreUtilities.toLowerCase(this.armorType.asString())) || this.tryItem(this.armor, eItem);
    }

    @Override
    public String getName() {
        return "PlayerEquipsArmor";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("armor")) {
            return this.armor;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        return super.getContext(name);
    }

    private void handleChangedArmor(final Player player, final String reason) {
        EntityEquipment oldEquipment = player.getEquipment();
        final ItemStack oldHelmet = oldEquipment.getHelmet();
        final ItemStack oldChestplate = oldEquipment.getChestplate();
        final ItemStack oldLeggings = oldEquipment.getLeggings();
        final ItemStack oldBoots = oldEquipment.getBoots();
        Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                EntityEquipment newEquipment = player.getEquipment();
                PlayerEquipsArmorScriptEvent.this.handleEvent(player, "helmet", oldHelmet, newEquipment.getHelmet(), reason);
                PlayerEquipsArmorScriptEvent.this.handleEvent(player, "chestplate", oldChestplate, newEquipment.getChestplate(), reason);
                PlayerEquipsArmorScriptEvent.this.handleEvent(player, "leggings", oldLeggings, newEquipment.getLeggings(), reason);
                PlayerEquipsArmorScriptEvent.this.handleEvent(player, "boots", oldBoots, newEquipment.getBoots(), reason);
            }
        }, 1L);
    }

    private void handleEvent(Player player, String type, ItemStack oldItem, ItemStack newItem, String reason) {
        if (!this.isSameItem(oldItem, newItem)) {
            if (this.isAir(oldItem)) {
                this.fireEquipsEvent(player, type, newItem, reason);
            } else if (this.isAir(newItem)) {
                this.fireUnequipsEvent(player, type, oldItem, reason);
            } else {
                this.fireUnequipsEvent(player, type, oldItem, reason);
                this.fireEquipsEvent(player, type, newItem, reason);
            }
        }
    }

    private void fireEquipsEvent(Player bukkitPlayer, String type, ItemStack newItem, String reasonString) {
        this.equipType = new Element("equips");
        this.armorType = new Element(type);
        this.reason = new Element(reasonString);
        this.armor = new dItem(newItem);
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)bukkitPlayer);
        this.fire();
    }

    private void fireUnequipsEvent(Player bukkitPlayer, String type, ItemStack oldItem, String reasonString) {
        this.equipType = new Element("unequips");
        this.armorType = new Element(type);
        this.reason = new Element(reasonString);
        this.armor = new dItem(oldItem);
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)bukkitPlayer);
        this.fire();
    }

    private boolean isSameItem(ItemStack oldItem, ItemStack newItem) {
        if (this.isAir(oldItem) || this.isAir(newItem)) {
            return this.isAir(oldItem) && this.isAir(newItem);
        }
        oldItem = oldItem.clone();
        oldItem.setDurability((short)0);
        newItem = newItem.clone();
        newItem.setDurability((short)0);
        return oldItem.equals((Object)newItem);
    }

    private boolean isAir(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    @EventHandler
    public void onBlockDispense(BlockDispenseEvent event) {
        Location location = event.getBlock().getLocation();
        for (Player player : location.getWorld().getPlayers()) {
            if (dEntity.isNPC((Entity)player) || !Utilities.checkLocation((LivingEntity)player, location, 2.5)) continue;
            this.handleChangedArmor(player, "DISPENSER");
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            this.handleChangedArmor((Player)humanEntity, "INVENTORY");
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            this.handleChangedArmor((Player)humanEntity, "INVENTORY");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.handleChangedArmor(event.getPlayer(), "INTERACT");
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            this.handleChangedArmor((Player)entity, "BREAK");
        }
    }
}

