/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.material;

import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.block.data.Ageable;

public class MaterialPlantGrowth
implements Property {
    public static final String[] handledTags = new String[]{"maximum_plant_growth", "plant_growth"};
    public static final String[] handledMechs = new String[]{"plant_growth"};
    dMaterial material;

    public static boolean describes(dObject material) {
        return material instanceof dMaterial && ((dMaterial)material).hasModernData() && ((dMaterial)material).getModernData().data instanceof Ageable;
    }

    public static MaterialPlantGrowth getFrom(dObject _material) {
        if (!MaterialPlantGrowth.describes(_material)) {
            return null;
        }
        return new MaterialPlantGrowth((dMaterial)_material);
    }

    private MaterialPlantGrowth(dMaterial _material) {
        this.material = _material;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("maximum_plant_growth")) {
            return new Element(this.getMax()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("plant_growth")) {
            return new Element(((Ageable)this.material.getModernData().data).getAge()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Ageable getAgeable() {
        return (Ageable)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getAgeable().getAge();
    }

    public int getMax() {
        return this.getAgeable().getMaximumAge();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "plant_growth";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("plant_growth") && mechanism.requireInteger()) {
            int growth = mechanism.getValue().asInt();
            if (growth < 0 || growth > this.getMax()) {
                dB.echoError("Growth value '" + growth + "' is not valid. Must be between 0 and " + this.getAgeable() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.getAgeable().setAge(growth);
        }
    }
}

