/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class RemoveCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("region") && arg.matchesPrefix("region", "r")) {
                scriptEntry.addObject("region", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        scriptEntry.defaultObject("world", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() && ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isSpawned() ? new dWorld(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getWorld()) : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().isOnline() ? new dWorld(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getWorld()) : null, new dWorld((World)Bukkit.getWorlds().get(0)));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        Element region = (Element)scriptEntry.getObject("region");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugList("entities", entities) + (region != null ? aH.debugObj("region", region) : ""));
        }
        for (dEntity entity : entities) {
            boolean conditionsMet = true;
            if (!entity.isGeneric()) {
                if (region != null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Region support is deprecated!");
                }
                if (!conditionsMet) continue;
                if (entity.isCitizensNPC()) {
                    entity.getDenizenNPC().getCitizen().destroy();
                    continue;
                }
                entity.remove();
                continue;
            }
            for (Entity worldEntity : world.getEntities()) {
                if (!entity.getEntityType().equals(DenizenEntityType.getByEntity(worldEntity))) continue;
                if (region != null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Region support is deprecated!");
                }
                if (!conditionsMet) continue;
                worldEntity.remove();
            }
        }
    }
}

