/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.HashSet;
import java.util.UUID;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class DisplayItemCommand
extends AbstractCommand
implements Listener {
    public final HashSet<UUID> protectedEntities = new HashSet();

    @Override
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(Duration.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matchesArgumentType(dItem.class) && !scriptEntry.hasObject("item")) {
                scriptEntry.addObject("item", arg.asType(dItem.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("item")) {
            throw new InvalidArgumentsException("Must specify an item to display.");
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", Duration.valueOf("1m"));
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.protectedEntities.contains(event.getEntity().getUniqueId()) || this.protectedEntities.contains(event.getTarget().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemInventoryPickup(InventoryPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemEntityPickup(EntityPickupItemEvent event) {
        if (this.protectedEntities.contains(event.getItem().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dItem item = (dItem)scriptEntry.getObject("item");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        dLocation location = (dLocation)scriptEntry.getObject("location");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), item.debug() + duration.debug() + location.debug());
        }
        final Item dropped = location.getWorld().dropItem(location.getBlock().getLocation().clone().add(0.5, 1.5, 0.5), item.getItemStack());
        dropped.setVelocity(dropped.getVelocity().multiply(0));
        dropped.setPickupDelay(duration.getTicksAsInt() + 1000);
        dropped.setTicksLived(duration.getTicksAsInt() + 1000);
        if (!dropped.isValid()) {
            return;
        }
        final UUID itemUUID = dropped.getUniqueId();
        this.protectedEntities.add(itemUUID);
        scriptEntry.addObject("dropped", new dEntity((Entity)dropped));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            @Override
            public void run() {
                if (dropped.isValid() && !dropped.isDead()) {
                    dropped.remove();
                    DisplayItemCommand.this.protectedEntities.remove(itemUUID);
                }
            }
        }, duration.getTicks());
    }
}

