/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.speech.DenizenSpeechContext;
import net.aufdemrand.denizen.npc.speech.DenizenSpeechController;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.entity.Entity;

public class ChatCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        boolean specified_targets = false;
        boolean specified_talker = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("target", "targets", "t")) {
                if (arg.matchesArgumentList(dEntity.class)) {
                    scriptEntry.addObject("targets", arg.asType(dList.class));
                }
                specified_targets = true;
                continue;
            }
            if (arg.matches("no_target")) {
                scriptEntry.addObject("targets", new dList());
                continue;
            }
            if (arg.matchesPrefix("talker", "talkers")) {
                if (arg.matchesArgumentList(dEntity.class)) {
                    scriptEntry.addObject("talkers", arg.asType(dList.class));
                }
                specified_talker = true;
                continue;
            }
            if (arg.matchesPrefix("range", "r")) {
                if (!arg.matchesPrimitive(aH.PrimitiveType.Double)) continue;
                scriptEntry.addObject("range", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("message")) {
                scriptEntry.addObject("message", new Element(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("targets") && ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && !specified_targets) {
            scriptEntry.defaultObject("targets", new dList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().identify()));
        }
        if (!scriptEntry.hasObject("talkers") && ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() && !specified_talker) {
            scriptEntry.defaultObject("talkers", new dList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().identify()));
        }
        if (!scriptEntry.hasObject("targets")) {
            throw new InvalidArgumentsException("Must specify valid targets!");
        }
        if (!scriptEntry.hasObject("talkers")) {
            throw new InvalidArgumentsException("Must specify valid talkers!");
        }
        if (!scriptEntry.hasObject("message")) {
            throw new InvalidArgumentsException("Must specify a message!");
        }
        scriptEntry.defaultObject("range", new Element(Settings.chatBystandersRange()));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dList talkers = (dList)scriptEntry.getdObject("talkers");
        dList targets = (dList)scriptEntry.getdObject("targets");
        Element message = scriptEntry.getElement("message");
        Element chatRange = scriptEntry.getElement("range");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), talkers.debug() + targets.debug() + message.debug() + chatRange.debug());
        }
        DenizenSpeechContext context = new DenizenSpeechContext(TagManager.cleanOutputFully(message.asString()), scriptEntry, chatRange.asDouble());
        if (!targets.isEmpty()) {
            for (dEntity ent : targets.filter(dEntity.class, scriptEntry)) {
                context.addRecipient(ent.getBukkitEntity());
            }
        }
        for (dEntity talker : talkers.filter(dEntity.class, scriptEntry)) {
            Entity entity = talker.getBukkitEntity();
            if (entity != null) {
                context.setTalker(entity);
                new DenizenSpeechController(entity).speak(context);
                continue;
            }
            dB.echoDebug((Debuggable)scriptEntry, "Chat Talker is not spawned! Cannot talk.");
        }
    }
}

