/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class TeamCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        String name = null;
        String prefix = null;
        String suffix = null;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesPrefix("id") && !scriptEntry.hasObject("id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("name") && !scriptEntry.hasObject("name")) {
                Element nameElement = arg.asElement();
                name = nameElement.asString();
                scriptEntry.addObject("name", nameElement);
                continue;
            }
            if (arg.matchesPrefix("add") && !scriptEntry.hasObject("add")) {
                scriptEntry.addObject("add", arg.asType(dList.class));
                continue;
            }
            if (arg.matchesPrefix("remove") && !scriptEntry.hasObject("remove")) {
                scriptEntry.addObject("remove", arg.asType(dList.class));
                continue;
            }
            if (arg.matchesPrefix("prefix") && !scriptEntry.hasObject("prefix")) {
                Element prefixElement = arg.asElement();
                prefix = prefixElement.asString();
                scriptEntry.addObject("prefix", prefixElement);
                continue;
            }
            if (!arg.matchesPrefix("suffix") || scriptEntry.hasObject("suffix")) continue;
            Element suffixElement = arg.asElement();
            suffix = suffixElement.asString();
            scriptEntry.addObject("suffix", suffixElement);
        }
        if (name == null || name.length() == 0 || name.length() > 16) {
            throw new InvalidArgumentsException("Must specify a team name between 1 and 16 characters!");
        }
        if (!(scriptEntry.hasObject("add") || scriptEntry.hasObject("remove") || scriptEntry.hasObject("prefix") || scriptEntry.hasObject("suffix"))) {
            throw new InvalidArgumentsException("Must specify something to do with the team!");
        }
        if (prefix != null && prefix.length() > 16 || suffix != null && suffix.length() > 16) {
            throw new InvalidArgumentsException("Prefixes and suffixes must be 16 characters or less!");
        }
        scriptEntry.defaultObject("id", new Element("main"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Scoreboard board;
        Team team;
        Element id = scriptEntry.getElement("id");
        Element name = scriptEntry.getElement("name");
        dList add = (dList)scriptEntry.getdObject("add");
        dList remove = (dList)scriptEntry.getdObject("remove");
        Element prefix = scriptEntry.getElement("prefix");
        Element suffix = scriptEntry.getElement("suffix");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), id.debug() + name.debug() + (add != null ? add.debug() : "") + (remove != null ? remove.debug() : "") + (prefix != null ? prefix.debug() : "") + (suffix != null ? suffix.debug() : ""));
        }
        if ((team = (board = id.asString().equalsIgnoreCase("main") ? ScoreboardHelper.getMain() : (ScoreboardHelper.hasScoreboard(id.asString()) ? ScoreboardHelper.getScoreboard(id.asString()) : ScoreboardHelper.createScoreboard(id.asString()))).getTeam(name.asString())) == null) {
            team = board.registerNewTeam(name.asString());
        }
        if (add != null) {
            for (String string : add) {
                if (string.startsWith("p@")) {
                    string = dPlayer.valueOf(string).getName();
                }
                if (team.hasEntry(string)) continue;
                team.addEntry(string);
            }
        }
        if (remove != null) {
            for (String string : remove) {
                if (string.startsWith("p@")) {
                    string = dPlayer.valueOf(string).getName();
                }
                if (!team.hasEntry(string)) continue;
                team.removeEntry(string);
            }
        }
        if (prefix != null) {
            team.setPrefix(prefix.asString());
        }
        if (suffix != null) {
            team.setSuffix(suffix.asString());
        }
        if (team.getEntries().isEmpty()) {
            team.unregister();
        }
    }
}

