/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class EntityKilledScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityKilledScriptEvent instance;
    public dEntity entity;
    public Element cause;
    public Element damage;
    public Element final_damage;
    public dEntity damager;
    public dEntity projectile;
    public EntityDamageEvent event;

    public EntityKilledScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("killed") || cmd.equals("kills");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target;
        String cmd = path.eventArgLowerAt(1);
        String arg0 = path.eventArgLowerAt(0);
        String arg2 = path.eventArgLowerAt(2);
        String arg3 = path.eventArgLowerAt(3);
        String attacker = cmd.equals("kills") ? arg0 : (arg2.equals("by") ? arg3 : "");
        String string = target = cmd.equals("kills") ? arg2 : arg0;
        if (!attacker.isEmpty() && (this.damager != null ? !this.cause.asString().equals(attacker) && !this.tryEntity(this.projectile, attacker) && !this.tryEntity(this.damager, attacker) : !this.cause.asString().equals(attacker))) {
            return false;
        }
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityKilled";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.damage = new Element(aH.getDoubleFrom(determination));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        dNPC npc;
        dPlayer player;
        dPlayer dPlayer2 = player = this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null;
        if (this.damager != null && player == null && this.damager.isPlayer()) {
            player = dEntity.getPlayerFrom(this.damager.getBukkitEntity());
        }
        dNPC dNPC2 = npc = this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null;
        if (this.damager != null && npc == null && this.damager.isCitizensNPC()) {
            npc = dEntity.getNPCFrom(this.damager.getBukkitEntity());
        }
        return new BukkitScriptEntryData(player, npc);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damage")) {
            return this.damage;
        }
        if (name.equals("final_damage")) {
            return this.final_damage;
        }
        if (name.equals("cause")) {
            return this.cause;
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager.getDenizenObject();
        }
        if (name.equals("projectile") && this.projectile != null) {
            return this.projectile.getDenizenObject();
        }
        if (name.startsWith("damage_")) {
            for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
                if (!name.equals("damage_" + CoreUtilities.toLowerCase(dm.name()))) continue;
                return new Element(this.event.getDamage(dm));
            }
        }
        return super.getContext(name);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityKilled(EntityDamageEvent event) {
        this.entity = new dEntity(event.getEntity());
        if (this.entity.isValid() && this.entity.isLivingEntity()) {
            if (event.getFinalDamage() < this.entity.getLivingEntity().getHealth()) {
                return;
            }
        } else {
            return;
        }
        this.damage = new Element(event.getDamage());
        this.final_damage = new Element(event.getFinalDamage());
        this.cause = new Element(CoreUtilities.toLowerCase(event.getCause().name()));
        this.damager = null;
        this.projectile = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new dEntity(((EntityDamageByEntityEvent)event).getDamager());
            if (this.damager.isProjectile()) {
                this.projectile = this.damager;
                if (this.damager.hasShooter()) {
                    this.damager = this.damager.getShooter();
                }
            }
        }
        this.event = event;
        this.fire((Cancellable)event);
        event.setDamage(this.damage.asDouble());
    }
}

