/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;

public class EntitySpawnerSpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntitySpawnerSpawnScriptEvent instance;
    private dEntity entity;
    private dLocation location;
    private dLocation spawnerLocation;
    public SpawnerSpawnEvent event;

    public EntitySpawnerSpawnScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("spawner spawns");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(2))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "SpawnerSpawn";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "location": {
                return this.location;
            }
            case "spawner_location": {
                return this.spawnerLocation;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        Entity entity = event.getEntity();
        this.entity = new dEntity(entity);
        this.location = new dLocation(event.getLocation());
        this.spawnerLocation = new dLocation(event.getSpawner().getLocation());
        this.event = event;
        dEntity.rememberEntity(entity);
        this.fire((Cancellable)event);
        dEntity.forgetEntity(entity);
    }
}

