/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;

public class ItemMoveScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemMoveScriptEvent instance;
    public dInventory origin;
    public dInventory destination;
    public dInventory initiator;
    public dItem item;
    public boolean itemSet;
    public InventoryMoveItemEvent event;

    public ItemMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("moves from");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryItem(this.item, CoreUtilities.getXthArg(0, path.eventLower))) {
            return false;
        }
        if (!this.tryInventory(this.origin, CoreUtilities.getXthArg(3, path.eventLower))) {
            return false;
        }
        if (CoreUtilities.xthArgEquals(4, path.eventLower, "to") && !this.tryInventory(this.destination, CoreUtilities.getXthArg(5, path.eventLower))) {
            return false;
        }
        return this.runInCheck(path, this.origin.getLocation());
    }

    @Override
    public String getName() {
        return "ItemMoves";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.item = dItem.valueOf(determination, container);
            this.itemSet = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("origin")) {
            return this.origin;
        }
        if (name.equals("destination")) {
            return this.destination;
        }
        if (name.equals("initiator")) {
            return this.initiator;
        }
        if (name.equals("item")) {
            return this.item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        this.origin = dInventory.mirrorBukkitInventory(event.getSource());
        this.destination = dInventory.mirrorBukkitInventory(event.getDestination());
        this.initiator = dInventory.mirrorBukkitInventory(event.getInitiator());
        this.item = new dItem(event.getItem());
        this.itemSet = false;
        this.fire((Cancellable)event);
        if (this.itemSet) {
            event.setItem(this.item.getItemStack());
        }
    }
}

