/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.nms.abstracts.ProfileEditor;
import net.aufdemrand.denizen.nms.interfaces.EntityHelper;
import net.aufdemrand.denizen.nms.interfaces.FakePlayer;
import net.aufdemrand.denizen.npc.traits.MirrorTrait;
import net.aufdemrand.denizen.objects.EntityFormObject;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.properties.entity.EntityAge;
import net.aufdemrand.denizen.objects.properties.entity.EntityColor;
import net.aufdemrand.denizen.objects.properties.entity.EntityTame;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.MaterialCompat;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WitherSkull;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class dEntity
implements dObject,
Adjustable,
EntityFormObject {
    public static HashSet<String> earlyValidMechanisms = new HashSet<String>(Arrays.asList("max_health", "health_data", "health"));
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    static final Pattern entity_by_id = Pattern.compile("(n@|e@|p@)(.+)", 2);
    static final Pattern entity_with_data = Pattern.compile("(\\w+),?(\\w+)?,?(\\w+)?", 2);
    private Entity entity = null;
    private DenizenEntityType entity_type = null;
    private String data1 = null;
    private String data2 = null;
    private DespawnedEntity despawned_entity = null;
    private dNPC npc = null;
    private UUID uuid = null;
    private String entityScript = null;
    private String prefix = "Entity";
    private ArrayList<Mechanism> mechanisms = new ArrayList();

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        return entity != null && Depends.citizens != null && CitizensAPI.hasImplementation() && CitizensAPI.getNPCRegistry().isNPC(entity);
    }

    public static dNPC getNPCFrom(Entity entity) {
        if (dEntity.isCitizensNPC(entity)) {
            return dNPC.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity != null && entity instanceof Player && !dEntity.isNPC(entity);
    }

    public static dPlayer getPlayerFrom(Entity entity) {
        if (dEntity.isPlayer(entity)) {
            return dPlayer.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public dItem getItemInHand() {
        if (this.isLivingEntity() && this.getLivingEntity().getEquipment() != null) {
            ItemStack its = this.getLivingEntity().getEquipment().getItemInHand();
            if (its == null) {
                return null;
            }
            return new dItem(its.clone());
        }
        return null;
    }

    public static dEntity getEntityFor(dObject object, TagContext context) {
        if (object instanceof dEntity) {
            return (dEntity)object;
        }
        if (object instanceof dPlayer && ((dPlayer)object).isOnline()) {
            return new dEntity((Entity)((dPlayer)object).getPlayerEntity());
        }
        if (object instanceof dNPC) {
            return new dEntity((dNPC)object);
        }
        return dEntity.valueOf(object.toString(), context);
    }

    public static dEntity valueOf(String string) {
        return dEntity.valueOf(string, null);
    }

    @Fetchable(value="e")
    public static dEntity valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
        if (m.matches()) {
            return ObjectFetcher.getObjectFrom(dEntity.class, string, context);
        }
        if (string.equalsIgnoreCase("RANDOM")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new dEntity(DenizenEntityType.getByName(randomType.name()), "RANDOM");
        }
        m = entity_by_id.matcher(string);
        if (m.matches()) {
            String entityGroup = m.group(1).toUpperCase();
            if (entityGroup.matches("N@")) {
                dNPC npc = dNPC.valueOf(string);
                if (npc != null) {
                    if (npc.isSpawned()) {
                        return new dEntity(npc);
                    }
                    if (context != null && context.debug) {
                        dB.echoDebug((Debuggable)context.entry, "NPC '" + string + "' is not spawned, errors may follow!");
                    }
                    return new dEntity(npc);
                }
                dB.echoError("NPC '" + string + "' does not exist!");
            } else if (entityGroup.matches("P@")) {
                Player returnable = dPlayer.valueOf(m.group(2)).getPlayerEntity();
                if (returnable != null) {
                    return new dEntity((Entity)returnable);
                }
                if (context == null || context.debug) {
                    dB.echoError("Invalid Player! '" + m.group(2) + "' could not be found. Has the player logged off?");
                }
            } else {
                try {
                    UUID entityID = UUID.fromString(m.group(2));
                    Entity entity = dEntity.getEntityForID(entityID);
                    if (entity != null) {
                        return new dEntity(entity);
                    }
                    return null;
                }
                catch (Exception entityID) {
                    // empty catch block
                }
            }
        }
        if (ScriptRegistry.containsScript(string = string.replace("e@", ""), EntityScriptContainer.class)) {
            return ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
        }
        m = entity_with_data.matcher(string);
        if (m.matches()) {
            String data1 = null;
            String data2 = null;
            if (m.group(2) != null) {
                data1 = m.group(2);
            }
            if (m.group(3) != null) {
                data2 = m.group(3);
            }
            if (DenizenEntityType.isRegistered(m.group(1))) {
                return new dEntity(DenizenEntityType.getByName(m.group(1)), data1, data2);
            }
        }
        try {
            UUID entityID = UUID.fromString(string);
            Entity entity = dEntity.getEntityForID(entityID);
            if (entity != null) {
                return new dEntity(entity);
            }
            return null;
        }
        catch (Exception exception) {
            if (context == null || context.debug) {
                dB.log("valueOf dEntity returning null: " + string);
            }
            return null;
        }
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = NMSHandler.getInstance().getEntityHelper().getEntity(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static boolean matches(String arg) {
        Matcher m = entity_by_id.matcher(arg);
        if (m.matches()) {
            return true;
        }
        if ((arg = arg.replace("e@", "").toUpperCase()).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        m = entity_with_data.matcher(arg);
        return m.matches() && DenizenEntityType.isRegistered(m.group(1));
    }

    public dEntity(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (dEntity.isCitizensNPC(entity)) {
                this.npc = dEntity.getNPCFrom(entity);
            }
        } else {
            dB.echoError("Entity referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    @Deprecated
    public dEntity(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    @Deprecated
    public dEntity(EntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
            this.data2 = data2;
        } else {
            dB.echoError("Entity_type referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public dEntity(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(DenizenEntityType entityType, String data1, String data2) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
            this.data2 = data2;
        } else {
            dB.echoError("DenizenEntityType referenced is null!");
        }
    }

    public dEntity(dNPC npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            dB.echoError("NPC referenced is null!");
        }
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSaveName() {
        String baseID = this.uuid.toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    @Override
    public dEntity getDenizenEntity() {
        return this;
    }

    public EntityFormObject getDenizenObject() {
        if (this.entity == null && this.npc == null) {
            return null;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new dPlayer(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public dNPC getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return dEntity.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || dEntity.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || dEntity.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public dPlayer getDenizenPlayer() {
        if (this.isPlayer()) {
            return new dPlayer(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        return this.entity instanceof Player && !this.isNPC();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public dEntity getShooter() {
        if (this.hasShooter()) {
            return new dEntity((Entity)((LivingEntity)this.getProjectile().getShooter()));
        }
        return null;
    }

    public void setShooter(dEntity shooter) {
        if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.isProjectile() && this.getProjectile().getShooter() != null && this.getProjectile().getShooter() instanceof LivingEntity;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public dInventory getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : dInventory.mirrorBukkitInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof FakePlayer) {
            return ((FakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return this.entity.getName();
        }
        String customName = this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public dList getEquipment() {
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        dList equipmentList = new dList();
        for (ItemStack item : equipment) {
            equipmentList.add(new dItem(item).identify());
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    public dLocation getLocation() {
        if (this.entity != null) {
            return new dLocation(this.entity.getLocation());
        }
        return null;
    }

    public dLocation getEyeLocation() {
        if (this.isPlayer()) {
            return new dLocation(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new dLocation(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new dLocation(this.getBukkitEntity().getLocation());
        }
        return null;
    }

    public Vector getVelocity() {
        if (!this.isGeneric()) {
            return this.entity.getVelocity();
        }
        return null;
    }

    public void setVelocity(Vector vector) {
        if (!this.isGeneric()) {
            if (this.entity instanceof WitherSkull) {
                ((WitherSkull)this.entity).setDirection(vector);
            } else {
                this.entity.setVelocity(vector);
            }
        }
    }

    public World getWorld() {
        if (!this.isGeneric()) {
            return this.entity.getWorld();
        }
        return null;
    }

    public void spawnAt(Location location) {
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else {
                this.getDenizenNPC().getCitizen().spawn(location);
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            }
        } else if (this.entity != null && this.isUnique()) {
            this.entity.teleport(location);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.getInstance().getEntityHelper().teleport(this.entity, location.toVector());
            }
        } else {
            if (this.entity_type != null) {
                Entity ent;
                if (this.despawned_entity != null) {
                    if (this.despawned_entity.custom_script == null) {
                        this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    }
                    this.getLivingEntity().teleport(location);
                    this.getLivingEntity().getEquipment().setArmorContents(this.despawned_entity.equipment);
                    this.getLivingEntity().setHealth(this.despawned_entity.health.doubleValue());
                    this.despawned_entity = null;
                } else if (this.entity_type.getName().equals("PLAYER")) {
                    if (Depends.citizens == null) {
                        dB.echoError("Cannot spawn entity of type PLAYER!");
                        return;
                    }
                    dNPC npc = new dNPC(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
                    npc.getCitizen().spawn(location);
                    this.entity = npc.getEntity();
                    this.uuid = this.entity.getUniqueId();
                } else if (this.entity_type.getName().equals("FALLING_BLOCK")) {
                    Material material = null;
                    if (this.data1 != null && dMaterial.matches(this.data1)) {
                        material = dMaterial.valueOf(this.data1).getMaterial();
                        while (this.data1.equalsIgnoreCase("RANDOM") && (!material.isBlock() || material == Material.AIR || material == MaterialCompat.NETHER_PORTAL || material == MaterialCompat.END_PORTAL)) {
                            material = dMaterial.valueOf(this.data1).getMaterial();
                        }
                    }
                    if (material == null || !material.isBlock()) {
                        material = Material.SAND;
                    }
                    byte materialData = 0;
                    if (this.data2 != null && aH.matchesInteger(this.data2)) {
                        materialData = (byte)aH.getIntegerFrom(this.data2);
                    }
                    this.entity = ent = location.getWorld().spawnFallingBlock(location, material, materialData);
                    this.uuid = this.entity.getUniqueId();
                } else {
                    this.entity = ent = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript);
                    if (this.entity == null) {
                        if (dB.verbose) {
                            dB.echoError("Failed to spawn entity of type " + this.entity_type.getName());
                        }
                        return;
                    }
                    this.uuid = this.entity.getUniqueId();
                    if (this.entityScript != null) {
                        EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
                    }
                }
            } else {
                dB.echoError("Cannot spawn a null dEntity!");
            }
            if (!this.isUnique()) {
                dB.echoError("Error spawning entity - bad entity type, blocked by another plugin, or tried to spawn in an unloaded chunk?");
                return;
            }
            for (Mechanism mechanism : this.mechanisms) {
                this.safeAdjust(new Mechanism(new Element(mechanism.getName()), mechanism.getValue(), mechanism.context));
            }
            this.mechanisms.clear();
        }
    }

    public void despawn() {
        this.despawned_entity = new DespawnedEntity(this);
        this.getLivingEntity().remove();
    }

    public void respawn() {
        if (this.despawned_entity != null) {
            this.spawnAt(this.despawned_entity.location);
        } else if (this.entity == null) {
            dB.echoError("Cannot respawn a null dEntity!");
        }
    }

    public boolean isSpawned() {
        return this.entity != null && this.isValid();
    }

    public boolean isValid() {
        return this.entity != null && this.entity.isValid();
    }

    public void remove() {
        EntityScriptHelper.unlinkEntity(this.entity);
        this.entity.remove();
    }

    public void teleport(Location location) {
        if (this.isCitizensNPC()) {
            this.getDenizenNPC().getCitizen().teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            this.entity.teleport(location);
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned() || !(this.entity instanceof Creature)) {
            dB.echoError(this.identify() + " is not a valid creature entity!");
            return;
        }
        NMSHandler.getInstance().getEntityHelper().setTarget((Creature)this.entity, target);
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(dEntity entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    public boolean comparedTo(String compare) {
        if ((compare = CoreUtilities.toLowerCase(compare)).equals("entity")) {
            return true;
        }
        if (compare.equals("player")) {
            return this.isPlayer();
        }
        if (compare.equals("npc")) {
            return this.isCitizensNPC() || this.isNPC();
        }
        if (this.getEntityScript() != null && compare.equals(CoreUtilities.toLowerCase(this.getEntityScript()))) {
            return true;
        }
        return compare.equals(this.getEntityType().getLowercaseName());
    }

    @Override
    public String getObjectType() {
        return "Entity";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dEntity setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        if (this.npc != null) {
            return "n@" + this.npc.getId();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return "p@" + this.getPlayer().getUniqueId();
            }
            if (this.isSpawned() || rememberedEntities.containsKey(this.entity.getUniqueId())) {
                return "e@" + this.entity.getUniqueId().toString();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            StringBuilder properties = new StringBuilder();
            for (Mechanism mechanism : this.mechanisms) {
                properties.append(mechanism.getName()).append("=").append(mechanism.getValue().asString().replace(';', '\u2011')).append(";");
            }
            String propertyOutput = "";
            if (properties.length() > 0) {
                propertyOutput = "[" + properties.substring(0, properties.length() - 1) + "]";
            }
            return "e@" + this.entity_type.getLowercaseName() + propertyOutput;
        }
        return "null";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String identifyType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return "e@" + this.entity_type.getName();
    }

    public String identifySimpleType() {
        if (this.isCitizensNPC()) {
            return "npc";
        }
        if (this.isPlayer()) {
            return "player";
        }
        return this.entity_type.getLowercaseName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return this.isPlayer() || this.isCitizensNPC() || this.isSpawned() || this.isLivingEntity() || this.entity != null && rememberedEntities.containsKey(this.entity.getUniqueId());
    }

    public boolean matchesEntity(String ent) {
        if (ent.equalsIgnoreCase("entity")) {
            return true;
        }
        if (ent.equalsIgnoreCase("npc")) {
            return this.isCitizensNPC();
        }
        if (ent.equalsIgnoreCase("player")) {
            return this.isPlayer();
        }
        if (ent.equalsIgnoreCase("vehicle")) {
            return this.entity instanceof Vehicle;
        }
        if (ent.equalsIgnoreCase("projectile")) {
            return this.entity instanceof Projectile;
        }
        if (ent.equalsIgnoreCase("hanging")) {
            return this.entity instanceof Hanging;
        }
        if (ent.equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (ent.equalsIgnoreCase(this.entity_type.getLowercaseName())) {
            return true;
        }
        if (this.entity != null && this.getEntityScript() != null) {
            return ent.equalsIgnoreCase(this.getEntityScript());
        }
        return this.uuid != null && this.uuid.toString().equals(ent);
    }

    @Override
    public String getAttribute(Attribute attribute) {
        dEntity toEntity;
        EntityHelper.MapTraceResult mtr;
        if (attribute == null) {
            return null;
        }
        if (this.entity == null && this.entity_type == null) {
            if (this.npc != null) {
                return new Element(this.identify()).getAttribute(attribute);
            }
            dB.echoError("dEntity has returned null.");
            return null;
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Entity").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entity_type")) {
            return new Element(this.entity_type.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_spawned")) {
            return new Element(this.isSpawned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eid")) {
            return new Element(this.entity.getEntityId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid")) {
            return new Element(this.getUUID().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("script")) {
            return new Element(this.entityScript == null ? "null" : this.entityScript).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (this.isPlayer() || this.isCitizensNPC()) {
                dB.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                return null;
            }
            return new Element(FlagManager.entityHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (this.isPlayer() || this.isCitizensNPC()) {
                dB.echoError("Reading flag for PLAYER or NPC as if it were an ENTITY!");
                return null;
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.entityHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.entityHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.entityHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getEntityFlag(this, flag_name);
                return new dList(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("list_flags")) {
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listEntityFlags(this));
            dList searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!CoreUtilities.toLowerCase(flag).contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
                DenizenAPI.getCurrentInstance().flagManager().shrinkEntityFlags(this, searchFlags);
            } else {
                DenizenAPI.getCurrentInstance().flagManager().shrinkEntityFlags(this, allFlags);
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (this.entity == null) {
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("custom_id")) {
            if (CustomNBT.hasCustomNBT((Entity)this.getLivingEntity(), "denizen-script-id")) {
                return new dScript(CustomNBT.getCustomNBT((Entity)this.getLivingEntity(), "denizen-script-id")).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.entity.getType().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("saddle")) {
            if (this.getLivingEntity().getType() == EntityType.HORSE) {
                return new dItem(((Horse)this.getLivingEntity()).getInventory().getSaddle()).getAttribute(attribute.fulfill(1));
            }
            if (this.getLivingEntity().getType() == EntityType.PIG) {
                return new dItem(((Pig)this.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR).getAttribute(attribute.fulfill(1));
            }
        }
        if ((attribute.startsWith("horse_armor") || attribute.startsWith("horse_armour")) && this.getLivingEntity().getType() == EntityType.HORSE) {
            return new dItem(((Horse)this.getLivingEntity()).getInventory().getArmor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_saddle")) {
            if (this.getLivingEntity().getType() == EntityType.HORSE) {
                return new Element(((Horse)this.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE).getAttribute(attribute.fulfill(1));
            }
            if (this.getLivingEntity().getType() == EntityType.PIG) {
                return new Element(((Pig)this.getLivingEntity()).hasSaddle()).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("item_in_hand") || attribute.startsWith("iteminhand")) {
            return new dItem(NMSHandler.getInstance().getEntityHelper().getItemInHand(this.getLivingEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_in_offhand") || attribute.startsWith("iteminoffhand")) {
            return new dItem(NMSHandler.getInstance().getEntityHelper().getItemInOffHand(this.getLivingEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_trading") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.entity instanceof Merchant) {
            return new Element(((Merchant)this.entity).isTrading()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trading_with") && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.entity instanceof Merchant && ((Merchant)this.entity).getTrader() != null) {
            return new dEntity((Entity)((Merchant)this.entity).getTrader()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("map_trace") && (mtr = NMSHandler.getInstance().getEntityHelper().mapTrace(this.getLivingEntity(), 200.0)) != null) {
            double x = 0.0;
            double y = 0.0;
            double basex = mtr.hitLocation.getX() - Math.floor(mtr.hitLocation.getX());
            double basey = mtr.hitLocation.getY() - Math.floor(mtr.hitLocation.getY());
            double basez = mtr.hitLocation.getZ() - Math.floor(mtr.hitLocation.getZ());
            if (mtr.angle == BlockFace.NORTH) {
                x = 128.0 - basex * 128.0;
            } else if (mtr.angle == BlockFace.SOUTH) {
                x = basex * 128.0;
            } else if (mtr.angle == BlockFace.WEST) {
                x = basez * 128.0;
            } else if (mtr.angle == BlockFace.EAST) {
                x = 128.0 - basez * 128.0;
            }
            y = 128.0 - basey * 128.0;
            return new dLocation(null, Math.round(x), Math.round(y)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_see") && this.isLivingEntity() && attribute.hasContext(1) && dEntity.matches(attribute.getContext(1)) && (toEntity = dEntity.valueOf(attribute.getContext(1))) != null && toEntity.isSpawned()) {
            return new Element(this.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_location")) {
            return new dLocation(this.getEyeLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("eye_height") && this.isLivingEntity()) {
            return new Element(this.getLivingEntity().getEyeHeight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location.cursor_on")) {
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            HashSet<Material> set = new HashSet<Material>();
            set.add(Material.AIR);
            attribute = attribute.fulfill(2);
            if (attribute.startsWith("ignore") && attribute.hasContext(1)) {
                List<dMaterial> ignoreList = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class, attribute.context);
                for (dMaterial material : ignoreList) {
                    set.add(material.getMaterial());
                }
                attribute = attribute.fulfill(1);
            }
            return new dLocation(this.getLivingEntity().getTargetBlock(set, range).getLocation()).getAttribute(attribute);
        }
        if (attribute.startsWith("location.standing_on")) {
            return new dLocation(this.entity.getLocation().clone().add(0.0, -0.5, 0.0)).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("location")) {
            return new dLocation(this.entity.getLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("body_yaw")) {
            return new Element(NMSHandler.getInstance().getEntityHelper().getBaseYaw(this.entity)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("velocity")) {
            return new dLocation(this.entity.getVelocity().toLocation(this.entity.getWorld())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return new dWorld(this.entity.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_pickup_items") && this.isLivingEntity()) {
            return new Element(this.getLivingEntity().getCanPickupItems()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fallingblock_material") && this.entity instanceof FallingBlock) {
            return new dMaterial(NMSHandler.getInstance().getEntityHelper().getBlockDataFor((FallingBlock)this.entity)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fall_distance")) {
            return new Element(this.entity.getFallDistance()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fire_time")) {
            return new Duration(this.entity.getFireTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("on_fire")) {
            return new Element(this.entity.getFireTicks() > 0).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("leash_holder") || attribute.startsWith("get_leash_holder")) && this.isLivingEntity() && this.getLivingEntity().isLeashed()) {
            return new dEntity(this.getLivingEntity().getLeashHolder()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && (attribute.startsWith("passengers") || attribute.startsWith("get_passengers"))) {
            ArrayList<dEntity> passengers = new ArrayList<dEntity>();
            for (Entity ent : this.entity.getPassengers()) {
                passengers.add(new dEntity(ent));
            }
            return new dList((Collection<? extends dObject>)passengers).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("passenger") || attribute.startsWith("get_passenger")) && !this.entity.isEmpty()) {
            return new dEntity(this.entity.getPassenger()).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("shooter") || attribute.startsWith("get_shooter")) && this.isProjectile() && this.hasShooter()) {
            return this.getShooter().getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && attribute.startsWith("left_shoulder")) {
            return new dEntity(((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && attribute.startsWith("right_shoulder")) {
            return new dEntity(((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("vehicle") || attribute.startsWith("get_vehicle")) && this.entity.isInsideVehicle()) {
            return new dEntity(this.entity.getVehicle()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("can_breed")) {
            return new Element(((Ageable)this.getLivingEntity()).canBreed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("breeding") || attribute.startsWith("is_breeding")) {
            return new Element(NMSHandler.getInstance().getEntityHelper().isBreeding((Animals)this.getLivingEntity())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_passenger")) {
            return new Element(!this.entity.isEmpty()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("empty") || attribute.startsWith("is_empty")) {
            return new Element(this.entity.isEmpty()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inside_vehicle") || attribute.startsWith("is_inside_vehicle")) {
            return new Element(this.entity.isInsideVehicle()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("leashed") || attribute.startsWith("is_leashed")) {
            return new Element(this.isLivingEntity() && this.getLivingEntity().isLeashed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sheared") && this.getBukkitEntity() instanceof Sheep) {
            return new Element(((Sheep)this.getBukkitEntity()).isSheared()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("on_ground") || attribute.startsWith("is_on_ground")) {
            return new Element(this.entity.isOnGround()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("persistent") || attribute.startsWith("is_persistent")) {
            return new Element(this.isLivingEntity() && !this.getLivingEntity().getRemoveWhenFarAway()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && attribute.startsWith("is_collidable")) {
            return new Element(this.getLivingEntity().isCollidable()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("killer")) {
            return dEntity.getPlayerFrom((Entity)this.getLivingEntity().getKiller()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_damage.amount")) {
            return new Element(this.getLivingEntity().getLastDamage()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.cause") && this.entity.getLastDamageCause() != null) {
            return new Element(this.entity.getLastDamageCause().getCause().name()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.duration")) {
            return new Duration((long)this.getLivingEntity().getNoDamageTicks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("last_damage.max_duration")) {
            return new Duration((long)this.getLivingEntity().getMaximumNoDamageTicks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Duration((long)this.getLivingEntity().getMaximumAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen")) {
            return new Duration((long)this.getLivingEntity().getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("remove_when_far")) {
            return new Element(this.getLivingEntity().getRemoveWhenFarAway()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("target")) {
            LivingEntity target;
            if (this.getBukkitEntity() instanceof Creature && (target = ((Creature)this.getLivingEntity()).getTarget()) != null) {
                return new dEntity((Entity)target).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("time_lived")) {
            return new Duration(this.entity.getTicksLived() / 20).getAttribute(attribute.fulfill(1));
        }
        if ((attribute.startsWith("pickup_delay") || attribute.startsWith("pickupdelay")) && this.getBukkitEntity() instanceof Item) {
            return new Duration(((Item)this.getBukkitEntity()).getPickupDelay() * 20).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && attribute.startsWith("gliding")) {
            return new Element(this.getLivingEntity().isGliding()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && attribute.startsWith("swimming")) {
            return new Element(this.getLivingEntity().isSwimming()).getAttribute(attribute.fulfill(1));
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && attribute.startsWith("glowing")) {
            return new Element(this.getBukkitEntity().isGlowing()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_living")) {
            return new Element(this.isLivingEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_monster")) {
            return new Element(this.getBukkitEntity() instanceof Monster).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_mob")) {
            return new Element(!this.isPlayer() && !this.isNPC() && this.isLivingEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_npc")) {
            return new Element(this.isCitizensNPC()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_player")) {
            return new Element(this.isPlayer()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_projectile")) {
            return new Element(this.isProjectile()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("tameable") || attribute.startsWith("is_tameable")) {
            return new Element(EntityTame.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ageable") || attribute.startsWith("is_ageable")) {
            return new Element(EntityAge.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("colorable") || attribute.startsWith("is_colorable")) {
            return new Element(EntityColor.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("experience") && this.getBukkitEntity() instanceof ExperienceOrb) {
            return new Element(((ExperienceOrb)this.getBukkitEntity()).getExperience()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed) {
            return new Element(((TNTPrimed)this.getBukkitEntity()).getFuseTicks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("dragon_phase") && this.getBukkitEntity() instanceof EnderDragon) {
            return new Element(((EnderDragon)this.getLivingEntity()).getPhase().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("describe")) {
            String escript = this.getEntityScript();
            return new Element("e@" + (escript != null && escript.length() > 0 ? escript : this.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(this)).getAttribute(attribute.fulfill(1));
        }
        String returned = CoreUtilities.autoPropertyTag(this, attribute);
        if (returned != null) {
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
        } else {
            dB.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    @Override
    public void adjust(Mechanism mechanism) {
        Entity bukkitEnt;
        dEntity ent2;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
            return;
        }
        if (this.getBukkitEntity() == null) {
            if (this.isCitizensNPC()) {
                dB.echoError("Cannot adjust not-spawned NPC " + this.getDenizenNPC());
            } else {
                dB.echoError("Cannot adjust entity " + this);
            }
            return;
        }
        if (mechanism.matches("item_in_hand")) {
            NMSHandler.getInstance().getEntityHelper().setItemInHand(this.getLivingEntity(), mechanism.valueAsType(dItem.class).getItemStack());
        }
        if (mechanism.matches("item_in_offhand")) {
            NMSHandler.getInstance().getEntityHelper().setItemInOffHand(this.getLivingEntity(), mechanism.valueAsType(dItem.class).getItemStack());
        }
        if (mechanism.matches("attach_to")) {
            if (mechanism.hasValue()) {
                Iterator list = mechanism.valueAsType(dList.class);
                Vector offset = null;
                boolean rotateWith = true;
                if (((ArrayList)((Object)list)).size() > 1) {
                    offset = dLocation.valueOf((String)((ArrayList)((Object)list)).get(1)).toVector();
                    if (((ArrayList)((Object)list)).size() > 2) {
                        rotateWith = new Element((String)((ArrayList)((Object)list)).get(2)).asBoolean();
                    }
                }
                NMSHandler.getInstance().forceAttachMove(this.entity, dEntity.valueOf((String)((ArrayList)((Object)list)).get(0)).getBukkitEntity(), offset, rotateWith);
            } else {
                NMSHandler.getInstance().forceAttachMove(this.entity, null, null, false);
            }
        }
        if (mechanism.matches("shooter")) {
            this.setShooter(mechanism.valueAsType(dEntity.class));
        }
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fallingblock_drop_item") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setDropItem(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fallingblock_hurt_entities") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setHurtEntities(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(Duration.class)) {
            this.entity.setFireTicks(mechanism.valueAsType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(dEntity.class)) {
            this.getLivingEntity().setLeashHolder(mechanism.valueAsType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && mechanism.requireBoolean()) {
            NMSHandler.getInstance().getEntityHelper().setBreeding((Animals)this.getLivingEntity(), mechanism.getValue().asBoolean());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_11_R1) && mechanism.matches("passengers")) {
            this.entity.eject();
            for (dEntity ent2 : mechanism.valueAsType(dList.class).filter(dEntity.class, mechanism.context)) {
                if (!ent2.isSpawned() || this.comparesTo(ent2) == 1) continue;
                this.entity.addPassenger(ent2.getBukkitEntity());
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(dEntity.class)) {
            this.entity.setPassenger(mechanism.valueAsType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(Duration.class)) {
            this.entity.setTicksLived(mechanism.valueAsType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("remaining_air") && mechanism.requireInteger()) {
            this.getLivingEntity().setRemainingAir(mechanism.getValue().asInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && mechanism.matches("release_left_shoulder") && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()) != null) {
            ent2 = new dEntity(bukkitEnt);
            String escript = ent2.getEntityScript();
            ent2 = dEntity.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : ent2.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(ent2));
            ent2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && mechanism.matches("release_right_shoulder") && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()) != null) {
            ent2 = new dEntity(bukkitEnt);
            String escript = ent2.getEntityScript();
            ent2 = dEntity.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : ent2.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(ent2));
            ent2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && mechanism.matches("left_shoulder")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(dEntity.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(mechanism.valueAsType(dEntity.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_12_R1) && this.getLivingEntity() instanceof HumanEntity && mechanism.matches("right_shoulder")) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(dEntity.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(mechanism.valueAsType(dEntity.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
            }
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sheared") && mechanism.requireBoolean() && this.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.getBukkitEntity()).setSheared(mechanism.getValue().asBoolean());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && mechanism.matches("collidable") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCollidable(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("no_damage_duration") && mechanism.requireObject(Duration.class)) {
            this.getLivingEntity().setNoDamageTicks(mechanism.valueAsType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("max_no_damage_duration") && mechanism.requireObject(Duration.class)) {
            this.getLivingEntity().setMaximumNoDamageTicks(mechanism.valueAsType(Duration.class).getTicksAsInt());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(dLocation.class)) {
            this.setVelocity(mechanism.valueAsType(dLocation.class).toVector());
        }
        if (mechanism.matches("move") && mechanism.requireObject(dLocation.class)) {
            NMSHandler.getInstance().getEntityHelper().move(this.getBukkitEntity(), mechanism.valueAsType(dLocation.class).toVector());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(dLocation.class)) {
            dLocation interactLocation = mechanism.valueAsType(dLocation.class);
            NMSHandler.getInstance().getEntityHelper().forceInteraction(this.getPlayer(), interactLocation);
        }
        if (mechanism.matches("play_death")) {
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        if ((mechanism.matches("pickup_delay") || mechanism.matches("pickupdelay")) && this.getBukkitEntity() instanceof Item && mechanism.requireObject(Duration.class)) {
            ((Item)this.getBukkitEntity()).setPickupDelay(mechanism.valueAsType(Duration.class).getTicksAsInt());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && mechanism.matches("gliding") && mechanism.requireBoolean()) {
            this.getLivingEntity().setGliding(mechanism.getValue().asBoolean());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_9_R2) && mechanism.matches("glowing") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setGlowing(mechanism.getValue().asBoolean());
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)this.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)this.getLivingEntity()).data().setPersistent("glowing", (Object)mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("dragon_phase")) {
            EnderDragon ed = (EnderDragon)this.getLivingEntity();
            ed.setPhase(EnderDragon.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("experience") && this.getBukkitEntity() instanceof ExperienceOrb && mechanism.requireInteger()) {
            ((ExperienceOrb)this.getBukkitEntity()).setExperience(mechanism.getValue().asInt());
        }
        if (mechanism.matches("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed && mechanism.requireInteger()) {
            ((TNTPrimed)this.getBukkitEntity()).setFuseTicks(mechanism.getValue().asInt());
        }
        if (mechanism.matches("show_to_players")) {
            NMSHandler.getInstance().getEntityHelper().unhideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("hide_from_players")) {
            NMSHandler.getInstance().getEntityHelper().hideEntity(null, this.getBukkitEntity(), false);
        }
        if (mechanism.matches("mirror_player") && mechanism.requireBoolean()) {
            if (this.isNPC()) {
                NPC npc = this.getDenizenNPC().getCitizen();
                if (!npc.hasTrait(MirrorTrait.class)) {
                    npc.addTrait(MirrorTrait.class);
                }
                MirrorTrait mirror = (MirrorTrait)npc.getTrait(MirrorTrait.class);
                if (mechanism.getValue().asBoolean()) {
                    mirror.enableMirror();
                } else {
                    mirror.disableMirror();
                }
            } else if (mechanism.getValue().asBoolean()) {
                ProfileEditor.mirrorUUIDs.add(this.getUUID());
            } else {
                ProfileEditor.mirrorUUIDs.remove(this.getUUID());
            }
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_13_R2) && mechanism.matches("swimming") && mechanism.requireBoolean()) {
            this.getLivingEntity().setSwimming(mechanism.getValue().asBoolean());
        }
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }

    private class DespawnedEntity {
        Double health = null;
        Location location = null;
        ItemStack[] equipment = null;
        String custom_script = null;

        public DespawnedEntity(dEntity entity) {
            if (entity != null) {
                this.health = entity.getLivingEntity().getHealth();
                this.location = entity.getLivingEntity().getLocation();
                this.equipment = entity.getLivingEntity().getEquipment().getArmorContents();
                if (CustomNBT.hasCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id")) {
                    this.custom_script = CustomNBT.getCustomNBT((Entity)entity.getLivingEntity(), "denizen-script-id");
                }
            }
        }
    }
}

