/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemEnchantments
implements Property {
    public static final String[] handledTags = new String[]{"is_enchanted", "enchantments"};
    public static final String[] handledMechs = new String[]{"remove_enchantments", "enchantments"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem;
    }

    public static ItemEnchantments getFrom(dObject _item) {
        if (!ItemEnchantments.describes(_item)) {
            return null;
        }
        return new ItemEnchantments((dItem)_item);
    }

    private ItemEnchantments(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        Set<Map.Entry<Enchantment, Integer>> enchantments;
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_enchanted")) {
            return new Element(this.getEnchantments().size() > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enchantments.with_levels") && (enchantments = this.getEnchantments()).size() > 0) {
            ArrayList<String> enchants = new ArrayList<String>();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(enchantment.getKey().getName() + "," + enchantment.getValue());
            }
            return new dList((List<String>)enchants).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.levels") && (enchantments = this.getEnchantments()).size() > 0) {
            ArrayList<String> enchants = new ArrayList<String>();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(String.valueOf(enchantment.getValue()));
            }
            return new dList((List<String>)enchants).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments.level") && attribute.hasContext(2)) {
            enchantments = this.getEnchantments();
            if (enchantments.size() > 0) {
                for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                    if (!enchantment.getKey().getName().equalsIgnoreCase(attribute.getContext(2))) continue;
                    return new Element(enchantment.getValue()).getAttribute(attribute.fulfill(2));
                }
            }
            return new Element(0).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("enchantments") && (enchantments = this.getEnchantments()).size() > 0) {
            ArrayList<String> enchants = new ArrayList<String>();
            for (Map.Entry<Enchantment, Integer> enchantment : enchantments) {
                enchants.add(enchantment.getKey().getName());
            }
            return new dList((List<String>)enchants).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Set<Map.Entry<Enchantment, Integer>> getEnchantments() {
        if (this.item.getItemStack().getEnchantments().size() > 0) {
            return this.item.getItemStack().getEnchantments().entrySet();
        }
        if (this.item.getItemStack().hasItemMeta() && this.item.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            return ((EnchantmentStorageMeta)this.item.getItemStack().getItemMeta()).getStoredEnchants().entrySet();
        }
        return new HashSet<Map.Entry<Enchantment, Integer>>();
    }

    @Override
    public String getPropertyString() {
        Set<Map.Entry<Enchantment, Integer>> enchants = this.getEnchantments();
        if (enchants.size() > 0) {
            StringBuilder returnable = new StringBuilder();
            for (Map.Entry<Enchantment, Integer> enchantment : enchants) {
                returnable.append(enchantment.getKey().getName()).append(",").append(enchantment.getValue()).append("|");
            }
            return returnable.substring(0, returnable.length() - 1);
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "enchantments";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("remove_enchantments")) {
            HashSet<String> names = null;
            if (mechanism.hasValue()) {
                names = new HashSet<String>();
                for (Object ench : mechanism.valueAsType(dList.class)) {
                    names.add(CoreUtilities.toLowerCase((String)ench));
                }
            }
            if (this.item.getItemStack().getType() == Material.ENCHANTED_BOOK) {
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemStack().getItemMeta();
                for (Enchantment ench : meta.getStoredEnchants().keySet()) {
                    if (names != null && !names.contains(CoreUtilities.toLowerCase(ench.getName()))) continue;
                    meta.removeStoredEnchant(ench);
                }
                this.item.getItemStack().setItemMeta((ItemMeta)meta);
            } else {
                for (Object ench : this.item.getItemStack().getEnchantments().keySet()) {
                    if (names != null && !names.contains(CoreUtilities.toLowerCase(ench.getName()))) continue;
                    this.item.getItemStack().removeEnchantment((Enchantment)ench);
                }
            }
        }
        if (mechanism.matches("enchantments")) {
            for (String enchant : mechanism.valueAsType(dList.class)) {
                if (!enchant.contains(",")) {
                    dB.echoError("Invalid enchantment format, use name,level|...");
                    continue;
                }
                String[] data = enchant.split(",", 2);
                if (Integer.valueOf(data[1]) == null) {
                    dB.echoError("Cannot apply enchantment '" + data[0] + "': '" + data[1] + "' is not a valid integer!");
                    continue;
                }
                try {
                    Enchantment ench;
                    ench = Enchantment.getByName((String)data[0].toUpperCase());
                    if (ench != null) {
                        if (this.item.getItemStack().getType() == Material.ENCHANTED_BOOK) {
                            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemStack().getItemMeta();
                            meta.addStoredEnchant(ench, Integer.valueOf(data[1]).intValue(), true);
                            this.item.getItemStack().setItemMeta((ItemMeta)meta);
                            continue;
                        }
                        this.item.getItemStack().addUnsafeEnchantment(ench, Integer.valueOf(data[1]).intValue());
                        continue;
                    }
                    dB.echoError("Unknown enchantment '" + data[0] + "'");
                }
                catch (NullPointerException e) {
                    dB.echoError("Unknown enchantment '" + data[0] + "'");
                }
            }
        }
    }
}

