/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class PermissionCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        if (Depends.permissions == null) {
            throw new InvalidArgumentsException("Permissions not linked - is Vault improperly installed, or is there no permissions plugin?");
        }
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("group") && arg.matchesPrefix("group")) {
                scriptEntry.addObject("group", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(dWorld.class)) {
                scriptEntry.addObject("world", arg.asType(dWorld.class));
                continue;
            }
            if (scriptEntry.hasObject("permission")) continue;
            scriptEntry.addObject("permission", arg.asElement());
        }
        if (!(scriptEntry.hasObject("group") || ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().isValid())) {
            throw new InvalidArgumentsException("Must have player context or a valid group!");
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
        if (!scriptEntry.hasObject("permission")) {
            throw new InvalidArgumentsException("Must specify a permission!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        Element permission = scriptEntry.getElement("permission");
        Element group = scriptEntry.getElement("group");
        dWorld world = (dWorld)scriptEntry.getObject("world");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + permission.debug() + (group != null ? group.debug() : "") + (world != null ? world.debug() : ""));
        }
        World bukkitWorld = null;
        if (world != null) {
            bukkitWorld = world.getWorld();
        }
        OfflinePlayer player = ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getOfflinePlayer() : null;
        switch (Action.valueOf(action.asString().toUpperCase())) {
            case ADD: {
                if (group != null) {
                    if (Depends.permissions.groupHas(bukkitWorld, group.asString(), permission.asString())) {
                        dB.echoDebug((Debuggable)scriptEntry, "Group " + group + " already has permission " + permission);
                    } else {
                        Depends.permissions.groupAdd(bukkitWorld, group.asString(), permission.asString());
                    }
                } else if (Depends.permissions.playerHas(bukkitWorld == null ? null : bukkitWorld.getName(), player, permission.asString())) {
                    dB.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " already has permission " + permission);
                } else {
                    Depends.permissions.playerAdd(bukkitWorld == null ? null : bukkitWorld.getName(), player, permission.asString());
                }
                return;
            }
            case REMOVE: {
                if (group != null) {
                    if (!Depends.permissions.groupHas(bukkitWorld, group.asString(), permission.asString())) {
                        dB.echoDebug((Debuggable)scriptEntry, "Group " + group + " does not have access to permission " + permission);
                    } else {
                        Depends.permissions.groupRemove(bukkitWorld, group.asString(), permission.asString());
                    }
                } else if (!Depends.permissions.playerHas(bukkitWorld == null ? null : bukkitWorld.getName(), player, permission.asString())) {
                    dB.echoDebug((Debuggable)scriptEntry, "Player " + player.getName() + " does not have access to permission " + permission);
                } else {
                    Depends.permissions.playerRemove(bukkitWorld == null ? null : bukkitWorld.getName(), player, permission.asString());
                }
                return;
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

