/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.interfaces.PacketHelper;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class AnimateChestCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(ChestAction.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.matchesPrefix("sound") && arg.matchesPrimitive(aH.PrimitiveType.Boolean)) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("players") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class).filter(dPlayer.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new Element("OPEN"));
        }
        if (!scriptEntry.hasObject("sound")) {
            scriptEntry.addObject("sound", new Element(true));
        }
        if (!scriptEntry.hasObject("players")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
                scriptEntry.addObject("players", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer()));
            } else {
                throw new InvalidArgumentsException("Missing 'players' argument!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        Element action = scriptEntry.getElement("action");
        Element sound = scriptEntry.getElement("sound");
        List players = (List)scriptEntry.getObject("players");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), location.debug() + action.debug() + sound.debug() + aH.debugObj("players", players.toString()));
        }
        PacketHelper packetHelper = NMSHandler.getInstance().getPacketHelper();
        switch (ChestAction.valueOf(action.asString().toUpperCase())) {
            case OPEN: {
                for (dPlayer player : players) {
                    Player ent = player.getPlayerEntity();
                    if (sound.asBoolean()) {
                        NMSHandler.getInstance().getSoundHelper().playSound(ent, (Location)location, NMSHandler.getInstance().getSoundHelper().getChestOpen(), 1.0f, 1.0f, "BLOCKS");
                    }
                    packetHelper.showBlockAction(ent, location, 1, 1);
                }
                break;
            }
            case CLOSE: {
                for (dPlayer player : players) {
                    Player ent = player.getPlayerEntity();
                    if (sound.asBoolean()) {
                        NMSHandler.getInstance().getSoundHelper().playSound(ent, (Location)location, NMSHandler.getInstance().getSoundHelper().getChestClose(), 1.0f, 1.0f, "BLOCKS");
                    }
                    packetHelper.showBlockAction(ent, location, 1, 0);
                }
                break;
            }
        }
    }

    static enum ChestAction {
        OPEN,
        CLOSE;

    }
}

