/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.text.DecimalFormat;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;

@Deprecated
public class FlagTags {
    Denizen denizen;

    public FlagTags(Denizen denizen) {
        this.denizen = denizen;
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                FlagTags.this.flagTag(event);
            }
        }, "flag");
    }

    public void flagTag(ReplaceableTagEvent event) {
        if (!event.matches("flag")) {
            return;
        }
        if (!event.hasValue()) {
            return;
        }
        dB.echoError(event.getAttributes().getScriptEntry().getResidingQueue(), "flag.x: tags are deprecated! Use <x.flag[]>, EG, <global.flag[name]>!");
        String flagName = event.getValue().split(":").length > 1 ? event.getValue().split(":")[0].toUpperCase() : event.getValue().toUpperCase();
        String flagFallback = event.hasAlternative() ? event.getAlternative().toString() : "EMPTY";
        int index = -1;
        ReplaceType replaceType = ReplaceType.ASSTRING;
        if (flagName.contains(".")) {
            try {
                int replaceTypeIndex = flagName.split("\\.").length - 1;
                replaceType = ReplaceType.valueOf(flagName.split("\\.")[replaceTypeIndex].replace("_", "").toUpperCase());
                flagName = flagName.replace("." + flagName.split("\\.")[replaceTypeIndex], "");
            }
            catch (Exception e) {
                replaceType = ReplaceType.ASSTRING;
            }
        }
        if (event.getType().toUpperCase().startsWith("G")) {
            if (!this.denizen.flagManager().getGlobalFlag(flagName).get(index).isEmpty()) {
                FlagManager.Flag flag = this.denizen.flagManager().getGlobalFlag(flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        } else if (event.getType().toUpperCase().startsWith("D") || event.getType().toUpperCase().startsWith("N")) {
            if (!this.denizen.flagManager().getNPCFlag(((BukkitTagContext)event.getContext()).npc.getId(), flagName).get(index).isEmpty()) {
                FlagManager.Flag flag = this.denizen.flagManager().getNPCFlag(((BukkitTagContext)event.getContext()).npc.getId(), flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        } else if (event.getType().toUpperCase().startsWith("P")) {
            dPlayer player = ((BukkitTagContext)event.getContext()).player;
            if (player == null) {
                return;
            }
            if (this.denizen.flagManager().getPlayerFlag(player, flagName).get(index).isEmpty()) {
                if (replaceType.toString().equals("ISEXPIRED")) {
                    event.setReplaced("true");
                }
            } else {
                FlagManager.Flag flag = this.denizen.flagManager().getPlayerFlag(player, flagName);
                event.setReplaced(this.getReplaceable(flag, flag.get(index), replaceType));
            }
        }
    }

    private String getReplaceable(FlagManager.Flag flag, FlagManager.Value value, ReplaceType replaceType) {
        switch (replaceType) {
            case ASINT: {
                return String.valueOf(value.asInteger());
            }
            case ASDOUBLE: {
                return String.valueOf(value.asDouble());
            }
            case ABS: {
                return String.valueOf(Math.abs(value.asDouble()));
            }
            case ASSTRING: {
                return value.asString();
            }
            case ASLIST: {
                return String.valueOf(value.asList());
            }
            case ASPLAYERLIST: {
                return String.valueOf(value.asList("p@"));
            }
            case ASNPCLIST: {
                return String.valueOf(value.asList("n@"));
            }
            case ASCSLIST: {
                return String.valueOf(value.asCommaSeparatedList());
            }
            case ASMONEY: {
                DecimalFormat d = new DecimalFormat("0.00");
                return String.valueOf(d.format(value.asDouble()));
            }
            case LENGTH: {
                return String.valueOf(value.asString().length());
            }
            case SIZE: {
                return String.valueOf(value.asSize());
            }
            case ISEXPIRED: {
                return String.valueOf(flag.checkExpired());
            }
            case EXPIRATION: {
                return String.valueOf(flag.expirationTime());
            }
        }
        return null;
    }

    private static enum ReplaceType {
        LENGTH,
        SIZE,
        ASSTRING,
        ABS,
        ASINT,
        ASDOUBLE,
        ASLIST,
        ASMONEY,
        ASPLAYERLIST,
        ASNPCLIST,
        ASCSLIST,
        ISEXPIRED,
        EXPIRATION;

    }
}

