/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import net.aufdemrand.denizencore.objects.CustomObject;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.commands.core.Comparable;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.SQLEscaper;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Element
implements dObject,
dObject.ObjectAttributable {
    @Deprecated
    public static final Element TRUE = new Element(Boolean.TRUE);
    @Deprecated
    public static final Element FALSE = new Element(Boolean.FALSE);
    @Deprecated
    public static final Element SERVER = new Element("server");
    @Deprecated
    public static final Element NULL = new Element("null");
    static final Pattern VALUE_PATTERN = Pattern.compile("el@val(?:ue)?\\[([^\\[\\]]+)\\].*", 42);
    private final String element;
    static final BigDecimal max = new BigDecimal("10E1000");
    private String prefix;
    public static HashMap<String, TagRunnable.ObjectForm> registeredObjectTags = new HashMap();

    public static Element valueOf(String string) {
        return Element.valueOf(string, null);
    }

    @Fetchable(value="el")
    public static Element valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = VALUE_PATTERN.matcher(string);
        if (m.matches()) {
            String value = m.group(1);
            return new Element(value);
        }
        return new Element(CoreUtilities.toLowerCase(string).startsWith("el@") ? string.substring(3) : string);
    }

    public static boolean matches(String string) {
        return string != null;
    }

    public static <T extends dObject> T handleNull(String tag, T object, String type, boolean has_fallback) {
        if (object == null) {
            if (!has_fallback) {
                dB.echoError("'" + tag + "' is an invalid " + type + "!");
            }
            return null;
        }
        return object;
    }

    public Element(String string) {
        this.prefix = "element";
        if (string == null) {
            if (dB.verbose) {
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                    dB.log("Element - Null construction!");
                }
            }
            this.element = "null";
        } else {
            this.element = TagManager.cleanOutput(string);
        }
    }

    public Element(boolean bool) {
        this.prefix = "boolean";
        this.element = String.valueOf(bool);
    }

    public Element(int integer) {
        this.prefix = "number";
        this.element = String.valueOf(integer);
    }

    public Element(byte byt) {
        this.prefix = "number";
        this.element = String.valueOf(byt);
    }

    public Element(short shrt) {
        this.prefix = "number";
        this.element = String.valueOf(shrt);
    }

    public Element(long lng) {
        this.prefix = "number";
        this.element = String.valueOf(lng);
    }

    public Element(BigDecimal bdl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.bigDecToString(bdl);
    }

    public Element(double dbl) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(dbl);
    }

    public Element(float flt) {
        this.prefix = "decimal";
        this.element = CoreUtilities.doubleToString(flt);
    }

    public Element(String prefix, String string) {
        this.prefix = prefix == null ? "element" : prefix;
        this.element = TagManager.cleanOutput(string);
    }

    private BigDecimal getBD(String text) {
        BigDecimal bd = new BigDecimal(text);
        if (bd.compareTo(max) >= 1) {
            dB.echoError("Unreasonably large number detected!");
            return max;
        }
        return bd;
    }

    public BigDecimal asBigDecimal() {
        return this.getBD(this.element.replaceAll("%", ""));
    }

    public double asDouble() {
        return Double.valueOf(this.element.replaceAll("%", ""));
    }

    public float asFloat() {
        return Float.valueOf(this.element.replaceAll("%", "")).floatValue();
    }

    public int asInt() {
        try {
            return Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            dB.echoError("'" + this.element + "' is not a valid integer!");
            return 0;
        }
    }

    public long asLong() {
        try {
            return Long.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
        }
        catch (NumberFormatException ex) {
            dB.echoError("'" + this.element + "' is not a valid integer!");
            return 0L;
        }
    }

    public boolean asBoolean() {
        return Boolean.valueOf(this.element.replaceAll("el@", ""));
    }

    public String asString() {
        return this.element;
    }

    public boolean isBoolean() {
        return this.element != null && (this.element.equalsIgnoreCase("true") || this.element.equalsIgnoreCase("false"));
    }

    public boolean isDouble() {
        try {
            if (!Double.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isFloat() {
        try {
            if (!Float.valueOf(this.element).isNaN()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isInt() {
        try {
            Integer val = Integer.valueOf(this.element.replaceAll("(%)|(\\.\\d+)", ""));
            if ((double)val.hashCode() != 0.5) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isString() {
        return this.element != null && !this.element.isEmpty();
    }

    public boolean matchesType(Class<? extends dObject> dClass) {
        return ObjectFetcher.checkMatch(dClass, this.element);
    }

    public <T extends dObject> T asType(Class<T> dClass) {
        return ObjectFetcher.getObjectFrom(dClass, this.element);
    }

    public <T extends dObject> T asType(Class<T> dClass, TagContext context) {
        return ObjectFetcher.getObjectFrom(dClass, this.element, context);
    }

    public boolean matchesEnum(Enum[] values) {
        for (Enum value : values) {
            if (!value.name().equalsIgnoreCase(this.element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getObjectType() {
        return "Element";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public String identify() {
        return this.element;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    public static void registerTags() {
        Element.registerTag("is", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (attribute.hasContext(1) && (attribute.startsWith("to", 2) || attribute.startsWith("than", 2)) && attribute.hasContext(2)) {
                    String operator;
                    Comparable com = new Comparable();
                    if (attribute.getContext(1).startsWith("!")) {
                        operator = attribute.getContext(1).substring(1);
                        com.setNegativeLogic();
                    } else {
                        operator = attribute.getContext(1);
                    }
                    Comparable.Operator comparableOperator = null;
                    try {
                        comparableOperator = Comparable.Operator.valueOf(operator.replace("==", "EQUALS").replace(">=", "OR_MORE").replace("<=", "OR_LESS").replace("<", "LESS").replace(">", "MORE").replace("=", "EQUALS").toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (comparableOperator != null) {
                        com.setOperator(comparableOperator);
                        com.setComparable(object.toString());
                        com.setComparedto(attribute.getContext(2));
                        return new Element(com.determineOutcome()).getObjectAttribute(attribute.fulfill(2));
                    }
                    dB.echoError("Unknown operator '" + operator + "'.");
                }
                return null;
            }
        });
        Element.registerTag("as_element", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return ((Element)object).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("aselement", registeredObjectTags.get("as_element"));
        Element.registerTag("as_boolean", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(element.equalsIgnoreCase("true") || element.equalsIgnoreCase("t") || element.equalsIgnoreCase("1")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("asboolean", registeredObjectTags.get("as_boolean"));
        Element.registerTag("as_decimal", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    return new Element(Double.valueOf(element)).getObjectAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("as_double", registeredObjectTags.get("as_decimal"));
        Element.registerTag("asdouble", registeredObjectTags.get("as_decimal"));
        Element.registerTag("as_int", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    return new Element(Double.valueOf(element).longValue()).getObjectAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("asint", registeredObjectTags.get("as_int"));
        Element.registerTag("as_money", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                try {
                    DecimalFormat d = new DecimalFormat("0.00");
                    return new Element(d.format(Double.valueOf(element))).getObjectAttribute(attribute.fulfill(1));
                }
                catch (NumberFormatException e) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("'" + element + "' is not a valid decimal number.");
                    }
                    return null;
                }
            }
        });
        Element.registerTag("asmoney", registeredObjectTags.get("as_money"));
        Element.registerTag("as_list", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList obj = Element.handleNull(element, dList.valueOf(element), "dList", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("aslist", registeredObjectTags.get("as_list"));
        Element.registerTag("as_custom", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                CustomObject obj = Element.handleNull(element, CustomObject.valueOf(element, null), "Custom", attribute.hasAlternative());
                if (obj != null) {
                    return obj.getObjectAttribute(attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("ascustom", registeredObjectTags.get("as_custom"));
        Element.registerTag("as_script", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dScript obj = Element.handleNull(element, dScript.valueOf(element), "dScript", attribute.hasAlternative());
                if (obj != null) {
                    return CoreUtilities.autoAttrib(obj, attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asscript", registeredObjectTags.get("as_script"));
        Element.registerTag("as_queue", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                ScriptQueue obj = Element.handleNull(element, ScriptQueue.valueOf(element), "ScriptQueue", attribute.hasAlternative());
                if (obj != null) {
                    return CoreUtilities.autoAttrib(obj, attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asqueue", registeredObjectTags.get("as_queue"));
        Element.registerTag("as_duration", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                Duration obj = Element.handleNull(element, Duration.valueOf(element), "Duration", attribute.hasAlternative());
                if (obj != null) {
                    return CoreUtilities.autoAttrib(obj, attribute.fulfill(1));
                }
                return null;
            }
        });
        Element.registerTag("asduration", registeredObjectTags.get("as_duration"));
        Element.registerTag("escaped", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(EscapeTags.escape(element)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("sql_escaped", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(SQLEscaper.escapeSQL(element)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("unescaped", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                return new Element(EscapeTags.unEscape(element)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("debug", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(object.debug()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("prefix", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(object.getPrefix()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("difference", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                String two = attribute.getContext(1);
                return new Element(CoreUtilities.getLevenshteinDistance(element, two)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("contains_any_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(attribute.getContext(1));
                for (String list_element : list) {
                    if (!element.contains(list_element)) continue;
                    return new Element(true).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(false).getObjectAttribute(attribute.fulfill(1));
            }
        });
        TagRunnable.ObjectForm r = registeredObjectTags.get("contains_any_case_sensitive").clone();
        r.name = null;
        Element.registerTag("contains_any_case_sensitive_text", r);
        Element.registerTag("contains_any", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)));
                String ellow = CoreUtilities.toLowerCase(element);
                for (String list_element : list) {
                    if (!ellow.contains(list_element)) continue;
                    return new Element(true).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(false).getObjectAttribute(attribute.fulfill(1));
            }
        });
        r = registeredObjectTags.get("contains_any").clone();
        r.name = null;
        Element.registerTag("contains_any_text", r);
        Element.registerTag("contains_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String contains;
                String element = ((Element)object).element;
                if (element.contains(contains = attribute.getContext(1))) {
                    return new Element("true").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("false").getObjectAttribute(attribute.fulfill(1));
            }
        });
        r = registeredObjectTags.get("contains_case_sensitive").clone();
        r.name = null;
        Element.registerTag("contains_case_sensitive_text", r);
        Element.registerTag("contains", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                String contains = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(contains).startsWith("regex:")) {
                    if (Pattern.compile(contains.substring("regex:".length()), 2).matcher(element).matches()) {
                        return new Element("true").getObjectAttribute(attribute.fulfill(1));
                    }
                    return new Element("false").getObjectAttribute(attribute.fulfill(1));
                }
                if (CoreUtilities.toLowerCase(element).contains(CoreUtilities.toLowerCase(contains))) {
                    return new Element("true").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("false").getObjectAttribute(attribute.fulfill(1));
            }
        });
        r = registeredObjectTags.get("contains").clone();
        r.name = null;
        Element.registerTag("contains_text", r);
        Element.registerTag("contains_all", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(CoreUtilities.toLowerCase(attribute.getContext(1)));
                String ellow = CoreUtilities.toLowerCase(element);
                for (String list_element : list) {
                    if (ellow.contains(list_element)) continue;
                    return new Element("false").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("true").getObjectAttribute(attribute.fulfill(1));
            }
        });
        r = registeredObjectTags.get("contains_all").clone();
        r.name = null;
        Element.registerTag("contains_all_text", r);
        Element.registerTag("contains_all_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String element = ((Element)object).element;
                dList list = dList.valueOf(attribute.getContext(1));
                for (String list_element : list) {
                    if (element.contains(list_element)) continue;
                    return new Element("false").getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("true").getObjectAttribute(attribute.fulfill(1));
            }
        });
        r = registeredObjectTags.get("contains_all_case_sensitive").clone();
        r.name = null;
        Element.registerTag("contains_all_case_sensitive_text", r);
        Element.registerTag("ends_with", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.toLowerCase(((Element)object).element).endsWith(CoreUtilities.toLowerCase(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("endswith", registeredObjectTags.get("ends_with"));
        Element.registerTag("equals_case_sensitive", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.equals_case_sensitive[...] must have a value.");
                    return null;
                }
                return new Element(((Element)object).element.equals(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("equals_with_case", registeredObjectTags.get("equals_case_sensitive"));
        Element.registerTag("matches", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.matches[...] must have a value.");
                    return null;
                }
                return new Element(((Element)object).element.matches(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("regex", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1) || !attribute.hasContext(2)) {
                    dB.echoError("The tag el@element.regex[...] must have a value.");
                    return null;
                }
                String regex = attribute.getContext(1);
                Matcher m = Pattern.compile(regex).matcher(((Element)object).element);
                if (!m.matches()) {
                    return null;
                }
                int group = new Element(attribute.getContext(2)).asInt();
                if (group < 0) {
                    group = 0;
                }
                if (group > m.groupCount()) {
                    group = m.groupCount();
                }
                return new Element(m.group(group)).getObjectAttribute(attribute.fulfill(2));
            }
        });
        Element.registerTag("length", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.length()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("not", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(!((Element)object).element.equalsIgnoreCase("true")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("and", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.equalsIgnoreCase("true") && attribute.getContext(1).equalsIgnoreCase("true")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("or", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.equalsIgnoreCase("true") || attribute.getContext(1).equalsIgnoreCase("true")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("xor", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.equalsIgnoreCase("true") != attribute.getContext(1).equalsIgnoreCase("true")).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("starts_with", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.toLowerCase(((Element)object).element).startsWith(CoreUtilities.toLowerCase(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("startswith", registeredObjectTags.get("starts_with"));
        Element.registerTag("index_of", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.index_of[...] must have a value.");
                    return null;
                }
                return new Element(CoreUtilities.toLowerCase(((Element)object).element).indexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("last_index_of", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.last_index_of[...] must have a value.");
                    return null;
                }
                return new Element(CoreUtilities.toLowerCase(((Element)object).element).lastIndexOf(CoreUtilities.toLowerCase(attribute.getContext(1))) + 1).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("char_at", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.char_at[...] must have a value.");
                    return null;
                }
                int index = attribute.getIntContext(1) - 1;
                if (index < 0 || index >= ((Element)object).element.length()) {
                    return null;
                }
                return new Element(String.valueOf(((Element)object).element.charAt(index))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("after_last", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.after_last[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(((Element)object).element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new Element(((Element)object).element.substring(CoreUtilities.toLowerCase(((Element)object).element).lastIndexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length())).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("").getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("after", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.after[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(((Element)object).element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new Element(((Element)object).element.substring(CoreUtilities.toLowerCase(((Element)object).element).indexOf(CoreUtilities.toLowerCase(delimiter)) + delimiter.length())).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element("").getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("before_last", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.before_last[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(((Element)object).element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new Element(((Element)object).element.substring(0, CoreUtilities.toLowerCase(((Element)object).element).lastIndexOf(CoreUtilities.toLowerCase(delimiter)))).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(((Element)object).element).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("before", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.before[...] must have a value.");
                    return null;
                }
                String delimiter = attribute.getContext(1);
                if (CoreUtilities.toLowerCase(((Element)object).element).contains(CoreUtilities.toLowerCase(delimiter))) {
                    return new Element(((Element)object).element.substring(0, CoreUtilities.toLowerCase(((Element)object).element).indexOf(CoreUtilities.toLowerCase(delimiter)))).getObjectAttribute(attribute.fulfill(1));
                }
                return new Element(((Element)object).element).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("replace", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.replace[...] must have a value.");
                    return null;
                }
                String replace = attribute.getContext(1);
                String replacement = "";
                attribute.fulfill(1);
                if (attribute.startsWith("with") && attribute.hasContext(1)) {
                    replacement = attribute.getContext(1);
                    if (replacement == null) {
                        replacement = "";
                    }
                    attribute.fulfill(1);
                }
                if (replace.startsWith("regex:")) {
                    return new Element(((Element)object).element.replaceAll(replace.substring("regex:".length()), replacement)).getObjectAttribute(attribute);
                }
                if (replace.startsWith("firstregex:")) {
                    return new Element(((Element)object).element.replaceFirst(replace.substring("firstregex:".length()), replacement)).getObjectAttribute(attribute);
                }
                return new Element(((Element)object).element.replaceAll("(?i)" + Pattern.quote(replace), replacement)).getObjectAttribute(attribute);
            }
        });
        r = registeredObjectTags.get("replace").clone();
        r.name = null;
        Element.registerTag("replace_text", r);
        Element.registerTag("format_number", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                try {
                    String afterdecimal;
                    String shortelement;
                    int decimal = ((Element)object).element.indexOf(46);
                    if (decimal != -1) {
                        shortelement = ((Element)object).element.substring(0, decimal);
                        afterdecimal = ((Element)object).element.substring(decimal);
                    } else {
                        shortelement = ((Element)object).element;
                        afterdecimal = "";
                    }
                    String intform = Long.valueOf(shortelement.replace("%", "")).toString();
                    String negative = "";
                    if (intform.startsWith("-")) {
                        negative = "-";
                        intform = intform.substring(1);
                    }
                    for (int i = intform.length() - 3; i > 0; i -= 3) {
                        intform = intform.substring(0, i) + "," + intform.substring(i);
                    }
                    return new Element(negative + intform + afterdecimal).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception ex) {
                    dB.echoError(ex);
                    return null;
                }
            }
        });
        Element.registerTag("to_list", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                dList list = new dList();
                for (int i = 0; i < ((Element)object).element.length(); ++i) {
                    list.add(String.valueOf(((Element)object).element.charAt(i)));
                }
                return list.getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("trim", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.trim()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("to_uppercase", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(((Element)object).element.toUpperCase()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("upper", registeredObjectTags.get("to_uppercase"));
        Element.registerTag("to_lowercase", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(CoreUtilities.toLowerCase(((Element)object).element)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("lower", registeredObjectTags.get("to_lowercase"));
        Element.registerTag("to_titlecase", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (((Element)object).element.length() == 0) {
                    return new Element("").getObjectAttribute(attribute.fulfill(1));
                }
                StringBuilder TitleCase = new StringBuilder(((Element)object).element.length());
                String Upper = ((Element)object).element.toUpperCase();
                String Lower = CoreUtilities.toLowerCase(((Element)object).element);
                TitleCase.append(Upper.charAt(0));
                for (int i = 1; i < ((Element)object).element.length(); ++i) {
                    if (((Element)object).element.charAt(i - 1) == ' ') {
                        TitleCase.append(Upper.charAt(i));
                        continue;
                    }
                    TitleCase.append(Lower.charAt(i));
                }
                return new Element(TitleCase.toString()).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("totitlecase", registeredObjectTags.get("to_titlecase"));
        Element.registerTag("substring", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.substring[...] must have a value.");
                    return null;
                }
                int beginning_index = new Element(attribute.getContext(1).split(",")[0]).asInt() - 1;
                int ending_index = attribute.getContext(1).split(",").length > 1 ? new Element(attribute.getContext(1).split(",")[1]).asInt() : ((Element)object).element.length();
                if (beginning_index < 0) {
                    beginning_index = 0;
                }
                if (beginning_index > ((Element)object).element.length()) {
                    beginning_index = ((Element)object).element.length();
                }
                if (ending_index > ((Element)object).element.length()) {
                    ending_index = ((Element)object).element.length();
                }
                if (ending_index < beginning_index) {
                    ending_index = beginning_index;
                }
                return new Element(((Element)object).element.substring(beginning_index, ending_index)).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("substr", registeredObjectTags.get("substring"));
        Element.registerTag("pad_left", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.pad_left[...] must have a value.");
                    return null;
                }
                String with = String.valueOf('\u00a0');
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = String.valueOf(attribute.getContext(1).charAt(0));
                    attribute = attribute.fulfill(1);
                }
                String padded = ((Element)object).element;
                while (padded.length() < length) {
                    padded = with + padded;
                }
                return new Element(padded).getObjectAttribute(attribute);
            }
        });
        Element.registerTag("pad_right", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.pad_right[...] must have a value.");
                    return null;
                }
                String with = String.valueOf('\u00a0');
                int length = attribute.getIntContext(1);
                if ((attribute = attribute.fulfill(1)).startsWith("with") && attribute.hasContext(1)) {
                    with = String.valueOf(attribute.getContext(1).charAt(0));
                    attribute = attribute.fulfill(1);
                }
                StringBuilder padded = new StringBuilder(((Element)object).element);
                while (padded.length() < length) {
                    padded.append(with);
                }
                return new Element(padded.toString()).getObjectAttribute(attribute);
            }
        });
        Element.registerTag("abs", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.abs(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("max", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.max(ele.asDouble(), new Element(attribute.getContext(1)).asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("min", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.min(ele.asDouble(), new Element(attribute.getContext(1)).asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("add_int", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(ele.asLong() + aH.getLongFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("div_int", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(ele.asLong() / aH.getLongFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("mul_int", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(ele.asLong() * aH.getLongFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("sub_int", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(ele.asLong() - aH.getLongFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("add", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.add[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new Element(ele.asBigDecimal().add(ele.getBD(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Throwable e) {
                    return new Element(ele.asDouble() + aH.getDoubleFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        Element.registerTag("div", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.div[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new Element(ele.asBigDecimal().divide(ele.getBD(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Throwable e) {
                    return new Element(ele.asDouble() / aH.getDoubleFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        Element.registerTag("mod", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.mod[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(ele.asDouble() % aH.getDoubleFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("mul", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.mul[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new Element(ele.asBigDecimal().multiply(ele.getBD(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Throwable e) {
                    return new Element(ele.asDouble() * aH.getDoubleFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        Element.registerTag("sub", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.sub[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                try {
                    return new Element(ele.asBigDecimal().subtract(ele.getBD(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Throwable e) {
                    return new Element(ele.asDouble() - aH.getDoubleFrom(attribute.getContext(1))).getObjectAttribute(attribute.fulfill(1));
                }
            }
        });
        Element.registerTag("sqrt", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.sqrt(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("log", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.log[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.log(ele.asDouble()) / Math.log(aH.getDoubleFrom(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("ln", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.log(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("power", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.power[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.pow(ele.asDouble(), aH.getDoubleFrom(attribute.getContext(1)))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("asin", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.asin(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("acos", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.acos(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("atan", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.atan(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("atan2", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.atan2[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.atan2(ele.asDouble(), attribute.getDoubleContext(1))).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("cos", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.cos(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("sin", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.sin(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("tan", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.tan(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("to_degrees", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.toDegrees(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("to_radians", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.toRadians(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_up", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element((long)Math.ceil(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_down", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element((long)Math.floor(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_to", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.round_to[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                int ten = (int)Math.pow(10.0, attribute.getIntContext(1));
                return new Element((double)Math.round(ele.asDouble() * (double)ten) / (double)ten).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                return new Element(Math.round(ele.asDouble())).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_to_precision", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.round_to_precision[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new Element((double)Math.round(ele.asDouble() / precision) * precision).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_down_to_precision", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.round_down_to_precision[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new Element(Math.floor(ele.asDouble() / precision) * precision).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("round_up_to_precision", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                if (!attribute.hasContext(1)) {
                    dB.echoError("The tag el@element.round_up_to_precision[...] must have a value.");
                    return null;
                }
                Element ele = (Element)object;
                if (!ele.isDouble()) {
                    dB.echoError("Element '" + ele + "' is not a valid decimal number!");
                    return null;
                }
                double precision = attribute.getDoubleContext(1);
                return new Element(Math.ceil(ele.asDouble() / precision) * precision).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("base64_encode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String encoded = Base64.getEncoder().encodeToString(((Element)object).element.getBytes());
                return new Element(encoded).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("base64_decode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String decoded = new String(Base64.getDecoder().decode(((Element)object).element));
                return new Element(decoded).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("hex_encode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String encoded = DatatypeConverter.printHexBinary((byte[])((Element)object).element.getBytes());
                return new Element(encoded).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("hex_decode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                String decoded = new String(DatatypeConverter.parseHexBinary((String)((Element)object).element));
                return new Element(decoded).getObjectAttribute(attribute.fulfill(1));
            }
        });
        Element.registerTag("url_encode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                try {
                    String encoded = URLEncoder.encode(((Element)object).element, "UTF-8");
                    return new Element(encoded).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception e) {
                    dB.echoError(e);
                    return null;
                }
            }
        });
        Element.registerTag("url_decode", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                try {
                    String decoded = URLDecoder.decode(((Element)object).element, "UTF-8");
                    return new Element(decoded).getObjectAttribute(attribute.fulfill(1));
                }
                catch (Exception e) {
                    dB.echoError(e);
                    return null;
                }
            }
        });
        Element.registerTag("type", new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element("Element").getObjectAttribute(attribute.fulfill(1));
            }
        });
    }

    public static void registerTag(String name, TagRunnable.ObjectForm runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        registeredObjectTags.put(name, runnable);
    }

    public static void registerTag(String name, final TagRunnable runnable) {
        if (runnable.name == null) {
            runnable.name = name;
        }
        Element.registerTag(name, new TagRunnable.ObjectForm(){

            @Override
            public dObject run(Attribute attribute, dObject object) {
                return new Element(runnable.run(attribute, object)).getObjectAttribute(attribute);
            }
        });
    }

    @Override
    public <T extends dObject> T asObjectType(Class<T> type, TagContext context) {
        return null;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        return CoreUtilities.stringifyNullPass(this.getObjectAttribute(attribute));
    }

    @Override
    public dObject getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            if (dB.verbose) {
                dB.log("Element - Attribute null!");
            }
            return null;
        }
        if (attribute.isComplete()) {
            if (dB.verbose) {
                dB.log("Element - Attribute complete! Self return! " + this.element);
            }
            return this;
        }
        String attrLow = CoreUtilities.toLowerCase(attribute.getAttributeWithoutContext(1));
        TagRunnable.ObjectForm otr = registeredObjectTags.get(attrLow);
        if (otr != null) {
            if (!otr.name.equals(attrLow)) {
                dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Using deprecated form of tag '" + otr.name + "': '" + attrLow + "'.");
            }
            if (dB.verbose) {
                dB.log("Element - run tag " + otr.name);
            }
            return otr.run(attribute, this);
        }
        if (attribute.startsWith("split") && attribute.startsWith("limit", 2)) {
            String split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            Integer limit = attribute.hasContext(2) ? attribute.getIntContext(2) : 1;
            if (CoreUtilities.toLowerCase(split_string).startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1], limit))).getObjectAttribute(attribute.fulfill(2));
            }
            return new dList(Arrays.asList(this.element.split("(?i)" + Pattern.quote(split_string), limit))).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("split")) {
            String split_string;
            String string = split_string = attribute.hasContext(1) ? attribute.getContext(1) : " ";
            if (CoreUtilities.toLowerCase(split_string).startsWith("regex:")) {
                return new dList(Arrays.asList(this.element.split(split_string.split(":", 2)[1]))).getObjectAttribute(attribute.fulfill(1));
            }
            return new dList(Arrays.asList(this.element.split("(?i)" + Pattern.quote(split_string)))).getObjectAttribute(attribute.fulfill(1));
        }
        dObject returned = CoreUtilities.autoPropertyTagObject(this, attribute);
        if (returned != null) {
            return returned;
        }
        if (attribute.isComplete()) {
            if (dB.verbose) {
                dB.log("Element - Secondary complete! Self return! " + this.element);
            }
            return this;
        }
        if (!attribute.hasAlternative()) {
            dB.echoDebug((Debuggable)attribute.getScriptEntry(), "Unfilled attributes '" + attribute.unfilledString() + "' for tag <" + attribute.getOrigin() + ">!");
        }
        if (dB.verbose) {
            dB.log("Element - Unfilled! Null!");
        }
        return null;
    }
}

