/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;

public class BlockDispensesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockDispensesScriptEvent instance;
    public dLocation location;
    public dItem item;
    private dLocation velocity;
    private dMaterial material;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("dispenses") && lower.length() >= 3;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        String dispenser = path.eventArgLowerAt(0);
        String iTest = path.eventArgLowerAt(2);
        return this.tryMaterial(this.material, dispenser) && (iTest.equals("item") || this.tryItem(this.item, iTest));
    }

    @Override
    public String getName() {
        return "BlockDispenses";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.velocity = new dLocation(this.velocity.multiply(aH.getDoubleFrom(determination)));
            return true;
        }
        if (dLocation.matches(determination)) {
            dLocation vel = dLocation.valueOf(determination);
            if (vel == null) {
                dB.echoError("[" + this.getName() + "] Invalid velocity!");
            } else {
                this.velocity = vel;
            }
        } else if (dItem.matches(determination)) {
            dItem it = dItem.valueOf(determination, container);
            if (it == null) {
                dB.echoError("[" + this.getName() + "] Invalid item!");
            } else {
                this.item = it;
            }
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("velocity")) {
            return this.velocity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = new dMaterial(event.getBlock());
        this.item = new dItem(event.getItem());
        this.velocity = new dLocation(null, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
        this.event = event;
        this.fire((Cancellable)event);
        event.setVelocity(this.velocity.toVector());
        event.setItem(this.item.getItemStack());
    }
}

