/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class EntityDeathScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDeathScriptEvent instance;
    public dEntity entity;
    public dObject damager;
    public Element message;
    public dInventory inventory;
    public Element cause;
    public dList drops;
    public List<dItem> dropItems;
    public Integer xp;
    public boolean keep_inv;
    public boolean keep_level;
    public EntityDeathEvent event;

    public EntityDeathScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String cmd = CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s));
        return cmd.equals("dies") || cmd.equals("death");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.tryEntity(this.entity, target)) {
            return false;
        }
        return this.runInCheck(path, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityDies";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("drops ")) {
            lower = lower.substring(6);
            determination = determination.substring(6);
        }
        if (lower.startsWith("no_drops")) {
            this.drops.clear();
            this.dropItems = new ArrayList<dItem>();
            if (lower.endsWith("_or_xp")) {
                this.xp = 0;
            }
        } else if (lower.equals("no_xp")) {
            this.xp = 0;
        } else if (lower.equals("keep_inv")) {
            this.keep_inv = true;
        } else if (lower.equals("keep_level")) {
            this.keep_level = true;
        } else if (aH.matchesInteger(determination)) {
            this.xp = aH.Argument.valueOf(lower).asElement().asInt();
        } else if (aH.Argument.valueOf(lower).matchesArgumentList(dItem.class)) {
            this.drops.clear();
            this.dropItems = new ArrayList<dItem>();
            dList drops_list = dList.valueOf(determination);
            drops_list.filter(dItem.class, container);
            for (String drop : drops_list) {
                dItem item = dItem.valueOf(drop, container);
                if (item == null) continue;
                this.dropItems.add(item);
                this.drops.add(item.identify());
            }
        } else if (this.event instanceof PlayerDeathEvent && !EntityDeathScriptEvent.isDefaultDetermination(determination)) {
            this.message = new Element(determination);
        } else {
            return super.applyDetermination(container, determination);
        }
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("damager") && this.damager != null) {
            return this.damager;
        }
        if (name.equals("message") && this.message != null) {
            return this.message;
        }
        if (name.equals("inventory") && this.inventory != null) {
            return this.inventory;
        }
        if (name.equals("cause") && this.cause != null) {
            return this.cause;
        }
        if (name.equals("drops") && this.drops != null) {
            return this.drops;
        }
        if (name.equals("xp") && this.xp != null) {
            return new Element(this.xp);
        }
        return super.getContext(name);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        dEntity.rememberEntity((Entity)livingEntity);
        this.entity = new dEntity((Entity)livingEntity);
        dPlayer player = null;
        if (this.entity.isPlayer()) {
            player = this.entity.getDenizenPlayer();
        }
        this.cause = null;
        this.damager = null;
        EntityDamageEvent lastDamage = this.entity.getBukkitEntity().getLastDamageCause();
        if (lastDamage != null) {
            this.cause = new Element(event.getEntity().getLastDamageCause().getCause().toString());
            if (lastDamage instanceof EntityDamageByEntityEvent) {
                dEntity damageEntity = new dEntity(((EntityDamageByEntityEvent)lastDamage).getDamager());
                dEntity shooter = damageEntity.getShooter();
                this.damager = shooter != null ? shooter.getDenizenObject() : damageEntity.getDenizenObject();
            } else if (livingEntity.getKiller() != null) {
                this.damager = new dEntity((Entity)livingEntity.getKiller()).getDenizenObject();
            }
        }
        this.message = null;
        this.inventory = null;
        PlayerDeathEvent subEvent = null;
        if (event instanceof PlayerDeathEvent) {
            subEvent = (PlayerDeathEvent)event;
            this.message = new Element(subEvent.getDeathMessage());
            if (player != null) {
                this.inventory = player.getInventory();
            }
            this.keep_inv = subEvent.getKeepInventory();
            this.keep_level = subEvent.getKeepLevel();
        }
        this.drops = new dList();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null) {
                this.drops.add("i@air");
                continue;
            }
            this.drops.add(new dItem(stack).identify());
        }
        this.cancelled = false;
        this.dropItems = null;
        this.xp = event.getDroppedExp();
        this.event = event;
        this.fire();
        event.setDroppedExp(this.xp.intValue());
        if (this.dropItems != null) {
            event.getDrops().clear();
            for (dItem drop : this.dropItems) {
                if (drop == null) continue;
                event.getDrops().add(drop.getItemStack());
            }
        }
        if (subEvent != null) {
            subEvent.setKeepInventory(this.keep_inv);
            subEvent.setKeepLevel(this.keep_level);
            if (this.message != null) {
                subEvent.setDeathMessage(this.message.asString());
            }
            if (this.cancelled) {
                subEvent.setDeathMessage(null);
            }
        }
        dEntity.forgetEntity((Entity)livingEntity);
    }
}

