/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;

public class ChatScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ChatScriptEvent instance;
    public PlayerChatEvent pcEvent;
    public AsyncPlayerChatEvent apcEvent;
    public Element message;
    public Element format;
    public dPlayer player;
    public Set<Player> recipients;
    public SyncChatHandler sch = new SyncChatHandler();
    public AsyncChatHandler asch = new AsyncChatHandler();
    boolean async = false;

    public ChatScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player chats");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return this.runInCheck(path, this.player.getLocation());
    }

    @Override
    public String getName() {
        return "Chat";
    }

    @Override
    public void init() {
        this.async = Settings.worldScriptChatEventAsynchronous();
        if (this.async) {
            this.initListener(this.asch);
        } else {
            this.initListener(this.sch);
        }
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("format:")) {
            String name = determination.substring("format:".length());
            FormatScriptContainer formatscr = (FormatScriptContainer)ScriptRegistry.getScriptContainer(name);
            if (formatscr == null) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Could not find format script matching '" + name + '\'');
            } else {
                String formatstr = formatscr.getFormatText(null, this.player);
                if (dB.verbose) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Setting format to " + formatstr);
                }
                this.format = new Element(formatstr);
            }
        } else if (lower.startsWith("raw_format:")) {
            String form = determination.substring("raw_format:".length());
            this.format = new Element(form);
        } else if (lower.startsWith("recipients:")) {
            String rec_new = determination.substring("recipients:".length());
            dList recs = dList.valueOf(rec_new);
            List<dPlayer> players = recs.filter(dPlayer.class, container);
            this.recipients.clear();
            for (dPlayer player : players) {
                this.recipients.add(player.getPlayerEntity());
            }
        } else if (!ChatScriptEvent.isDefaultDetermination(determination)) {
            this.message = new Element(determination);
        } else {
            return super.applyDetermination(container, determination);
        }
        return true;
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("message")) {
            return this.message;
        }
        if (name.equals("format")) {
            return this.format;
        }
        if (name.equals("recipients")) {
            dList list = new dList();
            for (Player tplayer : this.recipients) {
                list.add(dPlayer.mirrorBukkitPlayer((OfflinePlayer)tplayer).identify());
            }
            return list;
        }
        return super.getContext(name);
    }

    class AsyncChatHandler
    implements Listener {
        AsyncChatHandler() {
        }

        @EventHandler
        public void onAsyncChat(AsyncPlayerChatEvent event) {
            ChatScriptEvent.this.message = new Element(event.getMessage());
            ChatScriptEvent.this.format = new Element(event.getFormat());
            ChatScriptEvent.this.recipients = new HashSet<Player>(event.getRecipients());
            ChatScriptEvent.this.pcEvent = null;
            ChatScriptEvent.this.apcEvent = event;
            ChatScriptEvent.this.player = dEntity.getPlayerFrom((Entity)event.getPlayer());
            ChatScriptEvent.this.fire((Cancellable)event);
            event.setMessage(ChatScriptEvent.this.message.asString());
            event.setFormat(ChatScriptEvent.this.format.asString());
            event.getRecipients().clear();
            event.getRecipients().addAll(ChatScriptEvent.this.recipients);
        }
    }

    class SyncChatHandler
    implements Listener {
        SyncChatHandler() {
        }

        @EventHandler
        public void onSyncChat(PlayerChatEvent event) {
            ChatScriptEvent.this.message = new Element(event.getMessage());
            ChatScriptEvent.this.format = new Element(event.getFormat());
            ChatScriptEvent.this.recipients = new HashSet<Player>(event.getRecipients());
            ChatScriptEvent.this.pcEvent = event;
            ChatScriptEvent.this.apcEvent = null;
            ChatScriptEvent.this.player = dEntity.getPlayerFrom((Entity)event.getPlayer());
            ChatScriptEvent.this.fire((Cancellable)event);
            event.setMessage(ChatScriptEvent.this.message.asString());
            event.setFormat(ChatScriptEvent.this.format.asString());
            event.getRecipients().clear();
            event.getRecipients().addAll(ChatScriptEvent.this.recipients);
        }
    }
}

