/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;

public class PlayerKickedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerKickedScriptEvent instance;
    public dPlayer player;
    public Element message;
    public Element reason;
    public PlayerKickEvent event;

    public PlayerKickedScriptEvent() {
        instance = this;
    }

    public boolean isFlying() {
        return NMSHandler.getInstance().getPlayerHelper().getFlyKickCooldown(this.player.getPlayerEntity()) == 0;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player kicked");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(3).equals("flying")) {
            return this.isFlying();
        }
        return true;
    }

    @Override
    public String getName() {
        return "PlayerKicked";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        Duration duration;
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("message:")) {
            this.message = new Element(lower.substring("message:".length()));
            return true;
        }
        if (lower.startsWith("reason:")) {
            this.reason = new Element(lower.substring("reason:".length()));
            return true;
        }
        if (lower.startsWith("fly_cooldown:") && (duration = Duration.valueOf(lower.substring("fly_cooldown:".length()))) != null) {
            NMSHandler.getInstance().getPlayerHelper().setFlyKickCooldown(this.player.getPlayerEntity(), (int)duration.getTicks());
            this.cancelled = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("message")) {
            return this.message;
        }
        if (name.equals("reason")) {
            return this.reason;
        }
        if (name.equals("flying")) {
            return new Element(this.isFlying());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerKicked(PlayerKickEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.message = new Element(event.getLeaveMessage());
        this.reason = new Element(event.getReason());
        this.event = event;
        this.fire((Cancellable)event);
        event.setLeaveMessage(this.message.asString());
        event.setReason(this.reason.asString());
    }
}

