/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;

public class PlayerPreparesAnvilCraftScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerPreparesAnvilCraftScriptEvent instance;
    public boolean resultChanged;
    public dItem result;
    public AnvilInventory inventory;
    public dPlayer player;
    public Element repairCost;
    public Element newName;

    public PlayerPreparesAnvilCraftScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player prepares anvil craft");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String eItem = path.eventArgLowerAt(4);
        return this.tryItem(this.result, eItem);
    }

    @Override
    public String getName() {
        return "PlayerPreparesAnvilCraft";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesInteger(determination)) {
            this.repairCost = new Element(determination);
            return true;
        }
        if (dItem.matches(determination)) {
            this.result = dItem.valueOf(determination, container);
            this.resultChanged = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("item")) {
            return this.result;
        }
        if (name.equals("repair_cost")) {
            return this.repairCost;
        }
        if (name.equals("new_name")) {
            return this.newName;
        }
        if (name.equals("inventory")) {
            return dInventory.mirrorBukkitInventory((Inventory)this.inventory);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onCraftItem(PrepareAnvilEvent event) {
        if (event.getInventory().getViewers().size() == 0) {
            return;
        }
        HumanEntity humanEntity = (HumanEntity)event.getInventory().getViewers().get(0);
        if (dEntity.isNPC((Entity)humanEntity)) {
            return;
        }
        this.inventory = event.getInventory();
        this.repairCost = new Element(this.inventory.getRepairCost());
        this.newName = new Element(this.inventory.getRenameText());
        this.result = new dItem(event.getResult());
        this.player = dEntity.getPlayerFrom((Entity)humanEntity);
        this.resultChanged = false;
        this.cancelled = false;
        this.fire();
        this.inventory.setRepairCost(this.repairCost.asInt());
        if (this.resultChanged) {
            event.setResult(this.result.getItemStack());
        }
    }
}

