/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;

public class PlayerRespawnsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerRespawnsScriptEvent instance;
    public dLocation location;
    public PlayerRespawnEvent event;

    public PlayerRespawnsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("player respawns");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String loc = path.eventArgLowerAt(2);
        if (loc.equals("at") && !this.event.isBedSpawn()) {
            return false;
        }
        return !loc.equals("elsewhere") || !this.event.isBedSpawn();
    }

    @Override
    public String getName() {
        return "PlayerRespawns";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        dLocation loc;
        if (!CoreUtilities.toLowerCase(determination).equals("none") && (loc = dLocation.valueOf(determination)) != null) {
            this.location = loc;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerRespawns(PlayerRespawnEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.location = new dLocation(event.getRespawnLocation());
        this.event = event;
        this.fire();
        event.setRespawnLocation((Location)this.location);
    }
}

