/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlayerRightClicksEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    PlayerRightClicksEntityScriptEvent instance;
    PlayerInteractEntityEvent event;
    dEntity entity;
    dItem item;
    dLocation location;
    dList cuboids;

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player right clicks") && !CoreUtilities.getXthArg(3, lower).equals("at");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.tryEntity(this.entity, path.eventArgLowerAt(3))) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (!this.runWithCheck(path, new dItem(this.event.getPlayer().getItemInHand()))) {
            return false;
        }
        return !path.eventArgLowerAt(4).equals("with") || this.tryItem(new dItem(this.event.getPlayer().getItemInHand()), path.eventArgLowerAt(5));
    }

    @Override
    public String getName() {
        return "PlayerRightClicksEntity";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(dPlayer.mirrorBukkitPlayer((OfflinePlayer)this.event.getPlayer()), this.entity.isNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("cuboids")) {
            if (this.cuboids == null) {
                this.cuboids = new dList();
                for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
                    this.cuboids.add(cuboid.identifySimple());
                }
            }
            return this.cuboids;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void playerRightClicksEntity(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        this.entity = new dEntity(event.getRightClicked());
        this.item = new dItem(event.getPlayer().getItemInHand());
        this.location = new dLocation(event.getRightClicked().getLocation());
        this.cuboids = null;
        this.event = event;
        this.fire((Cancellable)event);
    }
}

