/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;

public class FurnaceSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static FurnaceSmeltsItemScriptEvent instance;
    public dItem source_item;
    public dItem result_item;
    public dLocation location;
    public FurnaceSmeltEvent event;

    public FurnaceSmeltsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("furnace smelts");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String resItem;
        String srcItem = path.eventArgLowerAt(2);
        if (!this.tryItem(this.source_item, srcItem)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into") && !this.tryItem(this.result_item, resItem = path.eventArgLowerAt(4))) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "FurnaceSmelts";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.result_item = dItem.valueOf(determination, container);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("source_item")) {
            return this.source_item;
        }
        if (name.equals("result_item")) {
            return this.result_item;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onFurnaceSmelts(FurnaceSmeltEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.source_item = new dItem(event.getSource());
        this.result_item = new dItem(event.getResult());
        this.event = event;
        this.fire((Cancellable)event);
        event.setResult(this.result_item.getItemStack());
    }
}

