/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;

public class WeatherChangesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static WeatherChangesScriptEvent instance;
    public dWorld world;
    public Element weather;
    public WeatherChangeEvent event;

    public WeatherChangesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(0, CoreUtilities.toLowerCase(s)).equals("weather");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String cmd = path.eventArgLowerAt(1);
        if (!cmd.equals("changes") && !cmd.equals(this.weather.identifySimple())) {
            return false;
        }
        String wCheck = path.eventArgLowerAt(3);
        return wCheck.length() <= 0 || wCheck.equals(CoreUtilities.toLowerCase(this.world.getName()));
    }

    @Override
    public String getName() {
        return "WeatherChanges";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("world")) {
            return this.world;
        }
        if (name.equals("weather")) {
            return this.weather;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onWeatherChanges(WeatherChangeEvent event) {
        this.world = new dWorld(event.getWorld());
        this.weather = new Element(event.toWeatherState() ? "rains" : "clears");
        this.event = event;
        this.fire((Cancellable)event);
    }
}

