/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class aH {
    static final Pattern floatPrimitive;
    static final Pattern doublePrimitive;
    static final Pattern percentagePrimitive;
    static final Pattern integerPrimitive;
    static final Pattern booleanPrimitive;
    static final Pattern wordPrimitive;
    public static List<String> specialInterpretTrickStrings;
    public static List<Argument> specialInterpretTrickObjects;
    private static final Pattern argsRegex;
    static final Pattern matchesScriptPtrn;

    public static List<Argument> interpretObjects(List<dObject> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (dObject obj : args) {
            arg_list.add(new Argument(obj));
        }
        return arg_list;
    }

    public static List<Argument> interpretArguments(List<Argument> args) {
        for (Argument arg : args) {
            if (!arg.needsFill && !arg.hasSpecialPrefix) continue;
            if (arg.object instanceof Element && arg.prefix == null) {
                arg.fillStr(arg.object.toString());
                continue;
            }
            arg.value = arg.object.toString();
            arg.lower_value = CoreUtilities.toLowerCase(arg.value);
            arg.raw_value = arg.generateRaw();
        }
        return args;
    }

    public static List<Argument> interpret(List<String> args) {
        if (args == specialInterpretTrickStrings) {
            return aH.interpretArguments(specialInterpretTrickObjects);
        }
        ArrayList<Argument> arg_list = new ArrayList<Argument>(args.size());
        for (String string : args) {
            arg_list.add(new Argument(string));
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = argsRegex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        if (dB.showScriptBuilder) {
            dB.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + (value != null ? value.toString() : "null") + "<G>'  ";
    }

    public static <T extends dObject> String debugList(String prefix, Collection<T> objects) {
        if (objects == null) {
            return aH.debugObj(prefix, null);
        }
        StringBuilder sb = new StringBuilder();
        for (dObject obj : objects) {
            String output = obj.debug();
            sb.append(output.substring((obj.getPrefix() + "='<A>").length(), output.length() - 6)).append(", ");
        }
        if (sb.length() == 0) {
            return aH.debugObj(prefix, sb);
        }
        return aH.debugObj(prefix, "[" + sb.substring(0, sb.length() - 2) + "]");
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + (value != null ? value.toString() : "null") + ")<G>'  ";
    }

    public static boolean matchesArg(String names, String string_arg) {
        String[] parts = names.split(",");
        if (parts.length == 1) {
            if (string_arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : parts) {
                if (!string_arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean matchesValueArg(String names, String string_arg, ArgumentType type) {
        if (string_arg == null) {
            return false;
        }
        int firstColonIndex = string_arg.indexOf(58);
        if (firstColonIndex == -1) {
            return false;
        }
        String[] commaParts = names.split(",");
        if (commaParts.length == 1) {
            if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : commaParts) {
                if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        string_arg = string_arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                return wordPrimitive.matcher(string_arg).matches();
            }
            case Integer: {
                return doublePrimitive.matcher(string_arg).matches();
            }
            case Double: {
                return doublePrimitive.matcher(string_arg).matches();
            }
            case Float: {
                return floatPrimitive.matcher(string_arg).matches();
            }
            case Boolean: {
                return booleanPrimitive.matcher(string_arg).matches();
            }
            case Script: {
                return true;
            }
            case String: {
                return true;
            }
            case Custom: {
                return true;
            }
        }
        dB.echoError("Invalid or temporarily unavailable matches value!");
        dB.echoError("While parsing '" + string_arg + "', Denizen has run into a problem. While the prefix is correct, the value is not valid. Check documentation for valid value.Perhaps a replaceable tag has failed to fill in a value?");
        return false;
    }

    public static boolean getBooleanFrom(String arg) {
        return Boolean.valueOf(aH.getStringFrom(arg));
    }

    public static double getDoubleFrom(String arg) {
        try {
            return Double.valueOf(aH.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static float getFloatFrom(String arg) {
        try {
            return Float.valueOf(aH.getStringFrom(arg)).floatValue();
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            return Double.valueOf(aH.getStringFrom(arg)).intValue();
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Deprecated
    public static dList getListFrom(String arg) {
        return dList.valueOf(aH.getStringFrom(arg));
    }

    public static long getLongFrom(String arg) {
        try {
            return Double.valueOf(aH.getStringFrom(arg)).longValue();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Deprecated
    public static dScript getScriptFrom(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("script:", "");
        return dScript.valueOf(arg);
    }

    public static String getStringFrom(String arg) {
        String[] parts = arg.split(":", 2);
        return parts.length >= 2 ? parts[1] : arg;
    }

    @Deprecated
    public static Duration getDurationFrom(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("duration:", "").replace("delay:", "");
        return Duration.valueOf(arg);
    }

    public static boolean matchesDouble(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesDuration(String arg) {
        arg = CoreUtilities.toLowerCase(arg).replace("duration:", "").replace("delay:", "");
        return Duration.matches(arg);
    }

    public static boolean matchesInteger(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesItem(String arg) {
        return arg.length() > 5 && arg.toUpperCase().startsWith("ITEM:");
    }

    @Deprecated
    public static boolean matchesContext(String arg) {
        return arg.toUpperCase().startsWith("CONTEXT:") || arg.toUpperCase().startsWith("DEFINE:");
    }

    @Deprecated
    public static Map<String, String> getContextFrom(String arg) {
        HashMap<String, String> context = new HashMap<String, String>();
        int x = 1;
        for (String ctxt : aH.getListFrom(arg)) {
            context.put(String.valueOf(x), ctxt.trim());
            ++x;
        }
        return context;
    }

    @Deprecated
    public static boolean matchesLocation(String arg) {
        return arg.toUpperCase().startsWith("LOCATION:");
    }

    @Deprecated
    public static boolean matchesQuantity(String arg) {
        return arg.toUpperCase().startsWith("QTY:");
    }

    @Deprecated
    public static boolean matchesQueue(String arg) {
        return arg.toUpperCase().startsWith("QUEUE:");
    }

    @Deprecated
    public static boolean matchesScript(String arg) {
        Matcher m = matchesScriptPtrn.matcher(arg);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(1))) {
                return true;
            }
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. This argument's format is correct, but Denizen couldn't locate a script named '" + m.group(1) + "'. Is it spelled correctly?");
        }
        return false;
    }

    @Deprecated
    public static boolean matchesState(String arg) {
        Pattern m = Pattern.compile("(state|toggle):(true|false|toggle)");
        if (m.matcher(arg).matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("(state|toggle):")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the prefix is correct, the value is not valid. 'STATE' requires a value of TRUE, FALSE, or TOGGLE. ");
        }
        return false;
    }

    static {
        doublePrimitive = floatPrimitive = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
        percentagePrimitive = Pattern.compile("-?(?:\\d+)?(\\.\\d+)?(%)?");
        integerPrimitive = Pattern.compile("(-)?\\d+");
        booleanPrimitive = Pattern.compile("true|false", 2);
        wordPrimitive = Pattern.compile("\\w+");
        specialInterpretTrickStrings = null;
        specialInterpretTrickObjects = null;
        argsRegex = Pattern.compile("[^\\s\"'\u00a8]+|\"([^\"]*)\"|'([^']*)'|\u00a8([^\u00a8]*)\u00a8");
        matchesScriptPtrn = Pattern.compile("script:(.+)", 2);
    }

    public static enum ArgumentType {
        LivingEntity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script,
        Duration;

    }

    public static class Argument
    implements Cloneable {
        public String raw_value;
        public String prefix = null;
        public String lower_prefix = null;
        public String value;
        public String lower_value;
        public dObject object = null;
        public boolean needsFill = false;
        public boolean hasSpecialPrefix = false;
        public ScriptEntry scriptEntry = null;

        public Argument clone() {
            try {
                return (Argument)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                dB.echoError(ex);
                return null;
            }
        }

        public String generateRaw() {
            return this.prefix == null ? this.value : this.prefix + ":" + this.value;
        }

        public Argument(String prefix, String value) {
            this.prefix = prefix;
            this.value = TagManager.cleanOutputFully(value);
            if (prefix != null) {
                if (prefix.equals("no_prefix")) {
                    this.prefix = null;
                    this.raw_value = this.value;
                } else {
                    this.raw_value = prefix + ":" + this.value;
                    this.lower_prefix = CoreUtilities.toLowerCase(prefix);
                }
            } else {
                this.raw_value = this.value;
            }
            this.lower_value = CoreUtilities.toLowerCase(this.value);
            this.object = new Element(this.value);
        }

        public Argument(String prefix, dObject value) {
            this.prefix = prefix;
            this.value = TagManager.cleanOutputFully(value.toString());
            if (prefix != null) {
                if (prefix.equals("no_prefix")) {
                    this.prefix = null;
                    this.raw_value = this.value;
                } else {
                    this.raw_value = prefix + ":" + this.value;
                    this.lower_prefix = CoreUtilities.toLowerCase(prefix);
                }
            } else {
                this.raw_value = this.value;
            }
            this.lower_value = CoreUtilities.toLowerCase(this.value);
            this.object = value instanceof Element ? new Element(this.value) : value;
        }

        public Argument(dObject obj) {
            this.object = obj;
            if (obj instanceof Element) {
                this.fillStr(obj.toString());
            } else {
                this.value = this.raw_value = TagManager.cleanOutputFully(obj.toString());
                this.lower_value = CoreUtilities.toLowerCase(this.value);
            }
        }

        void fillStr(String string) {
            this.raw_value = string = TagManager.cleanOutputFully(string);
            int first_colon = string.indexOf(58);
            int first_space = string.indexOf(32);
            if (first_space > -1 && first_space < first_colon || first_colon == -1) {
                this.value = string;
                if (this.object == null) {
                    this.object = new Element(this.value);
                }
            } else {
                this.prefix = string.substring(0, first_colon);
                if (this.prefix.equals("no_prefix")) {
                    this.prefix = null;
                } else {
                    this.lower_prefix = CoreUtilities.toLowerCase(this.prefix);
                }
                this.value = string.substring(first_colon + 1);
                this.object = new Element(this.value);
            }
            this.lower_value = CoreUtilities.toLowerCase(this.value);
        }

        public Argument(String string) {
            this.fillStr(string);
        }

        public static Argument valueOf(String string) {
            return new Argument(string);
        }

        public boolean startsWith(String string) {
            return this.lower_value.startsWith(CoreUtilities.toLowerCase(string));
        }

        public boolean hasPrefix() {
            return this.prefix != null;
        }

        public Argument getPrefix() {
            if (this.prefix == null) {
                return null;
            }
            return Argument.valueOf(this.prefix);
        }

        public boolean matches(String values) {
            for (String value : CoreUtilities.split(values, ',')) {
                if (!CoreUtilities.toLowerCase(value.replace(" ", "")).equals(this.lower_value)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesOne(String value) {
            return CoreUtilities.toLowerCase(value).equals(this.lower_value);
        }

        public boolean matches(String ... values) {
            for (String value : values) {
                if (!CoreUtilities.toLowerCase(value).equals(this.lower_value)) continue;
                return true;
            }
            return false;
        }

        public void replaceValue(String string) {
            this.value = string;
            this.lower_value = CoreUtilities.toLowerCase(this.value);
        }

        public String getValue() {
            return this.value;
        }

        public dList getList() {
            if (this.object instanceof dList) {
                return (dList)this.object;
            }
            return dList.valueOf(this.value);
        }

        public static HashSet<String> precalcEnum(Enum<?>[] values) {
            HashSet<String> toRet = new HashSet<String>(values.length);
            for (int i = 0; i < values.length; ++i) {
                toRet.add(values[i].name().toUpperCase().replace("_", ""));
            }
            return toRet;
        }

        public boolean matchesEnum(HashSet<String> values) {
            String upper = this.value.replace("_", "").toUpperCase();
            return values.contains(upper);
        }

        public boolean matchesEnumList(HashSet<String> values) {
            dList list = this.getList();
            for (String string : list) {
                String tval = string.replace("_", "").toUpperCase();
                if (!values.contains(tval)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesEnum(Enum<?>[] values) {
            String upper = this.value.replace("_", "").toUpperCase();
            for (Enum<?> value : values) {
                if (!value.name().replace("_", "").equals(upper)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesEnumList(Enum<?>[] values) {
            dList list = this.getList();
            for (String string : list) {
                String tval = string.replace("_", "").toUpperCase();
                for (Enum<?> value : values) {
                    if (!value.name().replace("_", "").equalsIgnoreCase(tval)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matchesPrefix(String values) {
            if (!this.hasPrefix()) {
                return false;
            }
            for (String value : CoreUtilities.split(values, ',')) {
                if (!CoreUtilities.toLowerCase(value.trim()).equals(this.lower_prefix)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesOnePrefix(String value) {
            if (!this.hasPrefix()) {
                return false;
            }
            return CoreUtilities.toLowerCase(value).equals(this.lower_prefix);
        }

        public boolean matchesPrefix(String ... values) {
            if (!this.hasPrefix()) {
                return false;
            }
            for (String value : values) {
                if (!CoreUtilities.toLowerCase(value).equals(this.lower_prefix)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesPrimitive(PrimitiveType argumentType) {
            if (this.value == null) {
                return false;
            }
            switch (argumentType) {
                case Word: {
                    return wordPrimitive.matcher(this.value).matches();
                }
                case Integer: {
                    return doublePrimitive.matcher(this.value).matches();
                }
                case Double: {
                    return doublePrimitive.matcher(this.value).matches();
                }
                case Float: {
                    return floatPrimitive.matcher(this.value).matches();
                }
                case Boolean: {
                    return booleanPrimitive.matcher(this.value).matches();
                }
                case Percentage: {
                    return percentagePrimitive.matcher(this.value).matches();
                }
                case String: {
                    return true;
                }
            }
            return false;
        }

        public boolean matchesArgumentType(Class<? extends dObject> dClass) {
            return CoreUtilities.canPossiblyBeType(this.object, dClass);
        }

        public boolean matchesArgumentTypes(Class<? extends dObject> ... dClasses) {
            for (Class<? extends dObject> c : dClasses) {
                if (!this.matchesArgumentType(c)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesArgumentList(Class<? extends dObject> dClass) {
            dList list = this.getList();
            return list.isEmpty() || list.containsObjectsFrom(dClass);
        }

        public Element asElement() {
            if (this.object instanceof Element) {
                return (Element)this.object;
            }
            return new Element(this.prefix, this.value);
        }

        public <T extends dObject> T asType(Class<T> clazz) {
            T arg = CoreUtilities.asType(this.object, clazz, DenizenCore.getImplementation().getTagContext(this.scriptEntry));
            if (arg != null) {
                arg.setPrefix(this.prefix);
                return arg;
            }
            return null;
        }

        public void reportUnhandled() {
            dB.echoError('\'' + this.raw_value + "' is an unknown argument!");
        }

        public String toString() {
            return this.raw_value;
        }
    }

    public static enum PrimitiveType {
        Float,
        Double,
        Integer,
        Boolean,
        String,
        Word,
        Percentage;

    }
}

