/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.nms.helpers;

import java.util.List;
import net.aufdemrand.denizen.nms.interfaces.FishingHelper;
import net.minecraft.server.v1_14_R1.Enchantment;
import net.minecraft.server.v1_14_R1.EnchantmentManager;
import net.minecraft.server.v1_14_R1.Enchantments;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EntityFishingHook;
import net.minecraft.server.v1_14_R1.EntityHuman;
import net.minecraft.server.v1_14_R1.EntityLiving;
import net.minecraft.server.v1_14_R1.LootTableInfo;
import net.minecraft.server.v1_14_R1.LootTableRegistry;
import net.minecraft.server.v1_14_R1.LootTables;
import net.minecraft.server.v1_14_R1.MathHelper;
import net.minecraft.server.v1_14_R1.StatisticList;
import net.minecraft.server.v1_14_R1.World;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_14_R1.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FishingHelper_v1_14_R1
implements FishingHelper {
    @Override
    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        net.minecraft.server.v1_14_R1.ItemStack result = null;
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        if (catchType == FishingHelper.CatchType.DEFAULT) {
            float f = ((CraftWorld)fishHook.getWorld()).getHandle().random.nextFloat();
            int i = EnchantmentManager.g((EntityLiving)nmsHook.owner);
            int j = EnchantmentManager.a((Enchantment)Enchantments.LURE, (EntityLiving)nmsHook.owner);
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            result = f < f1 ? this.catchRandomJunk(nmsHook) : ((f -= f1) < f2 ? this.catchRandomTreasure(nmsHook) : this.catchRandomFish(nmsHook));
        } else if (catchType == FishingHelper.CatchType.JUNK) {
            result = this.catchRandomJunk(nmsHook);
        } else if (catchType == FishingHelper.CatchType.TREASURE) {
            result = this.catchRandomTreasure(nmsHook);
        } else if (catchType == FishingHelper.CatchType.FISH) {
            result = this.catchRandomFish(nmsHook);
        }
        if (result != null) {
            return CraftItemStack.asBukkitCopy((net.minecraft.server.v1_14_R1.ItemStack)result);
        }
        return null;
    }

    @Override
    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addEntity((Entity)hook);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.server.v1_14_R1.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder(worldServer);
        LootTableRegistry registry = fishHook.getWorld().getMinecraftServer().getLootTableRegistry();
        List itemStacks = registry.getLootTable(LootTables.ac).populateLoot(playerFishEvent2.build(registry.getLootTable(LootTables.ac).getLootContextParameterSet()));
        return (net.minecraft.server.v1_14_R1.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }

    private net.minecraft.server.v1_14_R1.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder((WorldServer)fishHook.getWorld());
        LootTableRegistry registry = fishHook.getWorld().getMinecraftServer().getLootTableRegistry();
        List itemStacks = registry.getLootTable(LootTables.ad).populateLoot(playerFishEvent2.build(registry.getLootTable(LootTables.ad).getLootContextParameterSet()));
        return (net.minecraft.server.v1_14_R1.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }

    private net.minecraft.server.v1_14_R1.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        fishHook.owner.a(StatisticList.FISH_CAUGHT, 1);
        WorldServer worldServer = (WorldServer)fishHook.getWorld();
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder((WorldServer)fishHook.getWorld());
        LootTableRegistry registry = fishHook.getWorld().getMinecraftServer().getLootTableRegistry();
        List itemStacks = registry.getLootTable(LootTables.ae).populateLoot(playerFishEvent2.build(registry.getLootTable(LootTables.ae).getLootContextParameterSet()));
        return (net.minecraft.server.v1_14_R1.ItemStack)itemStacks.get(worldServer.random.nextInt(itemStacks.size()));
    }
}

