/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import java.util.ArrayList;
import java.util.Collection;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dTrade;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class EntityTrades
implements Property {
    public static final String[] handledTags = new String[]{"trades"};
    public static final String[] handledMechs = new String[]{"trades"};
    private dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntity() instanceof Merchant;
    }

    public static EntityTrades getFrom(dObject entity) {
        if (!EntityTrades.describes(entity)) {
            return null;
        }
        return new EntityTrades((dEntity)entity);
    }

    public dList getTradeRecipes() {
        if (this.entity.getBukkitEntity() instanceof Merchant) {
            ArrayList<dTrade> recipes = new ArrayList<dTrade>();
            for (MerchantRecipe recipe : ((Merchant)this.entity.getBukkitEntity()).getRecipes()) {
                recipes.add(new dTrade(recipe));
            }
            return new dList((Collection<? extends dObject>)recipes);
        }
        return null;
    }

    public EntityTrades(dEntity entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        if (((Merchant)this.entity.getBukkitEntity()).getRecipes() == null) {
            return null;
        }
        return this.getTradeRecipes().identify();
    }

    @Override
    public String getPropertyId() {
        return "trades";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("trades")) {
            return this.getTradeRecipes().getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("trades")) {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            for (dTrade recipe : mechanism.valueAsType(dList.class).filter(dTrade.class, mechanism.context)) {
                recipes.add(recipe.getRecipe());
            }
            ((Merchant)this.entity.getBukkitEntity()).setRecipes(recipes);
        }
    }
}

