/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.commands.entity.WalkCommandCitizensEvents;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.citizensnpcs.api.ai.Navigator;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WalkCommand
extends AbstractCommand
implements Holdable {
    public static List<ScriptEntry> held = new ArrayList<ScriptEntry>();

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("lookat") && arg.matchesPrefix("lookat") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("lookat", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Percentage) && arg.matchesPrefix("s, speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("auto_range") && arg.matches("auto_range")) {
                scriptEntry.addObject("auto_range", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("radius")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("stop") && arg.matches("stop")) {
                scriptEntry.addObject("stop", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location") && !scriptEntry.hasObject("stop")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("entities")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() == null || !((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isValid() || !((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isSpawned()) {
                throw new InvalidArgumentsException("Must have a valid spawned NPC attached.");
            }
            scriptEntry.addObject("entities", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()));
        }
        scriptEntry.defaultObject("stop", new Element(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dLocation loc = (dLocation)scriptEntry.getObject("location");
        Element speed = scriptEntry.getElement("speed");
        Element auto_range = scriptEntry.getElement("auto_range");
        Element radius = scriptEntry.getElement("radius");
        Element stop = scriptEntry.getElement("stop");
        List entities = (List)scriptEntry.getObject("entities");
        final dLocation lookat = (dLocation)scriptEntry.getdObject("lookat");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), (loc != null ? loc.debug() : "") + (speed != null ? speed.debug() : "") + (auto_range != null ? auto_range.debug() : "") + (radius != null ? radius.debug() : "") + (lookat != null ? lookat.debug() : "") + stop.debug() + aH.debugObj("entities", entities));
        }
        boolean shouldStop = stop.asBoolean();
        ArrayList<dNPC> npcs = new ArrayList<dNPC>();
        ArrayList<dEntity> waitForEntities = new ArrayList<dEntity>();
        for (final dEntity entity : entities) {
            if (entity.isCitizensNPC()) {
                dNPC npc = entity.getDenizenNPC();
                npcs.add(npc);
                if (!npc.isSpawned()) {
                    dB.echoError(scriptEntry.getResidingQueue(), "NPC " + npc.identify() + " is not spawned!");
                    continue;
                }
                if (shouldStop) {
                    npc.getNavigator().cancelNavigation();
                    continue;
                }
                if (auto_range != null && auto_range.asBoolean()) {
                    double distance = npc.getLocation().distance(loc);
                    if ((double)npc.getNavigator().getLocalParameters().range() < distance + 10.0) {
                        npc.getNavigator().getLocalParameters().range((float)distance + 10.0f);
                    }
                }
                npc.getNavigator().setTarget((Location)loc);
                if (lookat != null) {
                    npc.getNavigator().getLocalParameters().lookAtFunction((Function)new Function<Navigator, Location>(){

                        public Location apply(Navigator nav) {
                            return lookat;
                        }
                    });
                }
                if (speed != null) {
                    npc.getNavigator().getLocalParameters().speedModifier(speed.asFloat());
                }
                if (radius == null) continue;
                npc.getNavigator().getLocalParameters().addRunCallback((Runnable)WalkCommandCitizensEvents.generateNewFlocker(npc.getCitizen(), radius.asDouble()));
                continue;
            }
            if (shouldStop) {
                NMSHandler.getInstance().getEntityHelper().stopWalking(entity.getBukkitEntity());
                continue;
            }
            waitForEntities.add(entity);
            NMSHandler.getInstance().getEntityHelper().walkTo(entity.getBukkitEntity(), loc, speed != null ? speed.asDouble() : 0.2, new Runnable(){

                @Override
                public void run() {
                    WalkCommand.this.checkHeld(entity);
                }
            });
        }
        if (scriptEntry.shouldWaitFor()) {
            held.add(scriptEntry);
            if (!npcs.isEmpty()) {
                scriptEntry.addObject("tally", npcs);
            }
            if (!waitForEntities.isEmpty()) {
                scriptEntry.addObject("entities", waitForEntities);
            }
        }
    }

    public void checkHeld(dEntity entity) {
        for (int i = 0; i < held.size(); ++i) {
            ScriptEntry entry = held.get(i);
            List waitForEntities = (List)entry.getObject("entities");
            if (waitForEntities == null) continue;
            waitForEntities.remove(entity);
            if (!waitForEntities.isEmpty() || entry.hasObject("tally") && !((List)entry.getObject("tally")).isEmpty()) continue;
            entry.setFinished(true);
            held.remove(i);
            --i;
        }
    }

    @Override
    public void onEnable() {
        if (Depends.citizens != null) {
            DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new WalkCommandCitizensEvents(), (Plugin)DenizenAPI.getCurrentInstance());
        }
    }
}

