/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.trait.trait.Spawned;

public class DespawnCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("npcs") && arg.matchesArgumentList(dNPC.class)) {
                scriptEntry.addObject("npcs", arg.asType(dList.class).filter(dNPC.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("npcs")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
                scriptEntry.addObject("npcs", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC()));
            } else {
                throw new InvalidArgumentsException("Must specify a valid list of NPCs!");
            }
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List npcs = (List)scriptEntry.getObject("npcs");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugObj("NPCs", npcs.toString()));
        }
        for (dNPC npc : npcs) {
            if (!npc.isSpawned()) continue;
            if (npc.getCitizen().hasTrait(Spawned.class)) {
                ((Spawned)npc.getCitizen().getTrait(Spawned.class)).setSpawned(false);
            }
            npc.getCitizen().despawn(DespawnReason.PLUGIN);
        }
    }
}

