/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import java.util.ArrayList;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class ItemCooldownCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("materials") && (arg.matchesArgumentType(dMaterial.class) || arg.matchesArgumentType(dList.class))) {
                scriptEntry.addObject("materials", arg.asType(dList.class).filter(dMaterial.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesPrefix("d", "duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("materials")) {
            throw new InvalidArgumentsException("Missing materials argument!");
        }
        scriptEntry.defaultObject("duration", new Duration(1));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ArrayList materials = (ArrayList)scriptEntry.getObject("materials");
        Duration duration = (Duration)scriptEntry.getdObject("duration");
        dPlayer player = ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer();
        if (player == null) {
            dB.echoError("Invalid linked player.");
            return;
        }
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), aH.debugList("materials", materials) + duration.debug());
        }
        for (dMaterial mat : materials) {
            player.getPlayerEntity().setCooldown(mat.getMaterial(), duration.getTicksAsInt());
        }
    }
}

