/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.nms.NMSVersion;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class ChunkLoadCommand
extends AbstractCommand
implements Listener {
    Map<String, Long> chunkDelays = new HashMap<String, Long>();

    @Override
    public void onEnable() {
        Denizen denizen = DenizenAPI.getCurrentInstance();
        denizen.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)denizen);
        if (Depends.citizens != null) {
            denizen.getServer().getPluginManager().registerEvents((Listener)new ChunkLoadCommandNPCEvents(), (Plugin)denizen);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (arg.matchesEnum(Action.values()) && !scriptEntry.hasObject("action")) {
                scriptEntry.addObject("action", new Element(arg.getValue().toUpperCase()));
                if (!arg.getValue().equalsIgnoreCase("removeall")) continue;
                scriptEntry.addObject("location", new dLocation((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0));
                continue;
            }
            if (arg.matchesArgumentType(dChunk.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(dChunk.class).getCenter());
                continue;
            }
            if (arg.matchesArgumentType(dLocation.class) && !scriptEntry.hasObject("location")) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (arg.matchesArgumentType(Duration.class) && !scriptEntry.hasObject("duration")) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", new Element("ADD"));
        }
        if (!scriptEntry.hasObject("duration")) {
            scriptEntry.addObject("duration", new Duration(0));
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Element action = scriptEntry.getElement("action");
        dLocation chunkloc = (dLocation)scriptEntry.getObject("location");
        Duration length = (Duration)scriptEntry.getObject("duration");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), action.debug() + chunkloc.debug() + length.debug());
        }
        final Chunk chunk = chunkloc.getChunk();
        final String chunkString = chunk.getX() + ", " + chunk.getZ() + "," + chunkloc.getWorldName();
        switch (Action.valueOf(action.asString())) {
            case ADD: {
                if (length.getSeconds() != 0.0) {
                    this.chunkDelays.put(chunkString, System.currentTimeMillis() + length.getMillis());
                } else {
                    this.chunkDelays.put(chunkString, 0L);
                }
                dB.echoDebug((Debuggable)scriptEntry, "...added chunk " + chunk.getX() + ", " + chunk.getZ() + " with a delay of " + length.getSeconds() + " seconds.");
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                if (!NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14_R1)) break;
                chunk.setForceLoaded(true);
                if (!(length.getSeconds() > 0.0)) break;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (ChunkLoadCommand.this.chunkDelays.containsKey(chunkString) && ChunkLoadCommand.this.chunkDelays.get(chunkString) <= System.currentTimeMillis()) {
                            chunk.setForceLoaded(false);
                            ChunkLoadCommand.this.chunkDelays.remove(chunkString);
                        }
                    }
                }, length.getTicks() + 20L);
                break;
            }
            case REMOVE: {
                if (this.chunkDelays.containsKey(chunkString)) {
                    this.chunkDelays.remove(chunkString);
                    if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14_R1)) {
                        chunk.setForceLoaded(false);
                    }
                    dB.echoDebug((Debuggable)scriptEntry, "...allowing unloading of chunk " + chunk.getX() + ", " + chunk.getZ());
                    break;
                }
                dB.echoError("Chunk was not on the load list!");
                break;
            }
            case REMOVEALL: {
                dB.echoDebug((Debuggable)scriptEntry, "...allowing unloading of all stored chunks");
                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_14_R1)) {
                    for (String chunkStr : this.chunkDelays.keySet()) {
                        dChunk loopChunk = dChunk.valueOf(chunkStr);
                        loopChunk.getChunk().setForceLoaded(false);
                    }
                }
                this.chunkDelays.clear();
            }
        }
    }

    @EventHandler
    public void stopUnload(ChunkUnloadEvent e) {
        if (!(e instanceof Cancellable)) {
            return;
        }
        String chunkString = e.getChunk().getX() + ", " + e.getChunk().getZ();
        if (this.chunkDelays.containsKey(chunkString)) {
            if (this.chunkDelays.get(chunkString) == 0L) {
                ((Cancellable)e).setCancelled(true);
            } else if (System.currentTimeMillis() < this.chunkDelays.get(chunkString)) {
                ((Cancellable)e).setCancelled(true);
            } else {
                this.chunkDelays.remove(chunkString);
            }
        }
    }

    public class ChunkLoadCommandNPCEvents
    implements Listener {
        @EventHandler
        public void stopDespawn(NPCDespawnEvent e) {
            if (e.getNPC() == null || !e.getNPC().isSpawned()) {
                return;
            }
            Chunk chnk = e.getNPC().getEntity().getLocation().getChunk();
            String chunkString = chnk.getX() + ", " + chnk.getZ();
            if (ChunkLoadCommand.this.chunkDelays.containsKey(chunkString)) {
                if (ChunkLoadCommand.this.chunkDelays.get(chunkString) == 0L) {
                    e.setCancelled(true);
                } else if (System.currentTimeMillis() < ChunkLoadCommand.this.chunkDelays.get(chunkString)) {
                    e.setCancelled(true);
                } else {
                    ChunkLoadCommand.this.chunkDelays.remove(chunkString);
                }
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        REMOVEALL;

    }
}

