/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkCommand
extends AbstractCommand {
    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("random")) {
                scriptEntry.addObject("type", new Element(FireworkEffect.Type.values()[CoreUtilities.getRandom().nextInt(FireworkEffect.Type.values().length)].name()));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum((Enum<?>[])FireworkEffect.Type.values())) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("power") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("power", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("flicker") && arg.matches("flicker")) {
                scriptEntry.addObject("flicker", "");
                continue;
            }
            if (!scriptEntry.hasObject("trail") && arg.matches("trail")) {
                scriptEntry.addObject("trail", "");
                continue;
            }
            if (!scriptEntry.hasObject("primary") && arg.matchesPrefix("primary") && arg.matchesArgumentList(dColor.class)) {
                scriptEntry.addObject("primary", arg.asType(dList.class).filter(dColor.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("fade") && arg.matchesPrefix("fade") && arg.matchesArgumentList(dColor.class)) {
                scriptEntry.addObject("fade", arg.asType(dList.class).filter(dColor.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getLocation() : null, ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getLocation() : null);
        scriptEntry.defaultObject("type", new Element("ball"));
        scriptEntry.defaultObject("power", new Element(1));
        scriptEntry.defaultObject("primary", Arrays.asList(dColor.valueOf("yellow")));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getLocation();
        Element type = (Element)scriptEntry.getObject("type");
        Element power = (Element)scriptEntry.getObject("power");
        boolean flicker = scriptEntry.hasObject("flicker");
        boolean trail = scriptEntry.hasObject("trail");
        List primary = (List)scriptEntry.getObject("primary");
        List fade = (List)scriptEntry.getObject("fade");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), location.debug() + type.debug() + power.debug() + (flicker ? aH.debugObj("flicker", flicker) : "") + (trail ? aH.debugObj("trail", trail) : "") + aH.debugObj("primary colors", primary.toString()) + (fade != null ? aH.debugObj("fade colors", fade.toString()) : ""));
        }
        Firework firework = (Firework)location.getWorld().spawn((Location)location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.setPower(power.asInt());
        FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
        fireworkBuilder.with(FireworkEffect.Type.valueOf((String)type.asString().toUpperCase()));
        fireworkBuilder.withColor(Conversion.convertColors(primary));
        if (fade != null) {
            fireworkBuilder.withFade(Conversion.convertColors(fade));
        }
        if (flicker) {
            fireworkBuilder.withFlicker();
        }
        if (trail) {
            fireworkBuilder.withTrail();
        }
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkBuilder.build()});
        firework.setFireworkMeta(fireworkMeta);
        scriptEntry.addObject("launched_firework", new dEntity((Entity)firework));
    }
}

