/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.nms.interfaces.BlockData;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.blocks.CuboidBlockSet;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;

public class SchematicCommand
extends AbstractCommand
implements Holdable,
Listener {
    public static boolean noPhys = false;
    public static Map<String, CuboidBlockSet> schematics;

    @Override
    public void onEnable() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                SchematicCommand.this.schematicTags(event);
            }
        }, "schematic", "schem");
        schematics = new HashMap<String, CuboidBlockSet>();
        noPhys = false;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (noPhys) {
            event.setCancelled(true);
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpretArguments(scriptEntry.aHArgs)) {
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", new Element(arg.raw_value.toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("name") && arg.matchesPrefix("name")) {
                scriptEntry.addObject("name", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("filename") && arg.matchesPrefix("filename")) {
                scriptEntry.addObject("filename", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("angle") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("angle", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("cuboid") && arg.matchesArgumentType(dCuboid.class)) {
                scriptEntry.addObject("cuboid", arg.asType(dCuboid.class));
                continue;
            }
            if (!scriptEntry.hasObject("delayed") && arg.matches("delayed")) {
                scriptEntry.addObject("delayed", new Element("true"));
                continue;
            }
            if (!scriptEntry.hasObject("noair") && arg.matches("noair")) {
                scriptEntry.addObject("noair", new Element("true"));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Missing type argument!");
        }
        if (!scriptEntry.hasObject("name")) {
            throw new InvalidArgumentsException("Missing name argument!");
        }
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) {
        Element angle = scriptEntry.getElement("angle");
        Element type = scriptEntry.getElement("type");
        Element name = scriptEntry.getElement("name");
        Element filename = scriptEntry.getElement("filename");
        Element noair = scriptEntry.getElement("noair");
        Element delayed = scriptEntry.getElement("delayed");
        dLocation location = (dLocation)scriptEntry.getdObject("location");
        dCuboid cuboid = (dCuboid)scriptEntry.getdObject("cuboid");
        if (scriptEntry.dbCallShouldDebug()) {
            dB.report(scriptEntry, this.getName(), type.debug() + name.debug() + (location != null ? location.debug() : "") + (filename != null ? filename.debug() : "") + (cuboid != null ? cuboid.debug() : "") + (angle != null ? angle.debug() : "") + (noair != null ? noair.debug() : "") + (delayed != null ? delayed.debug() : ""));
        }
        Type ttype = Type.valueOf(type.asString());
        if (scriptEntry.shouldWaitFor() && ttype != Type.PASTE) {
            dB.echoError("Tried to wait for a non-paste schematic command.");
            scriptEntry.setFinished(true);
        }
        String fname = filename != null ? filename.asString() : name.asString();
        switch (ttype) {
            case CREATE: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                if (cuboid == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing cuboid argument!");
                    return;
                }
                if (location == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing origin location argument!");
                    return;
                }
                try {
                    CuboidBlockSet set = new CuboidBlockSet(cuboid, location);
                    schematics.put(name.asString().toUpperCase(), set);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error creating schematic object " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case LOAD: {
                if (schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is already loaded.");
                    return;
                }
                try {
                    String directory = URLDecoder.decode(System.getProperty("user.dir"));
                    File f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schematic");
                    if (!Utilities.canReadFile(f)) {
                        dB.echoError("Server config denies reading files in that location.");
                        return;
                    }
                    if (!f.exists()) {
                        dB.echoError("Schematic file " + fname + " does not exist. Are you sure it's in " + directory + "/plugins/Denizen/schematics/?");
                        return;
                    }
                    FileInputStream fs = new FileInputStream(f);
                    CuboidBlockSet set = CuboidBlockSet.fromMCEditStream(fs);
                    ((InputStream)fs).close();
                    schematics.put(name.asString().toUpperCase(), set);
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error loading schematic file " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case UNLOAD: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.remove(name.asString().toUpperCase());
                break;
            }
            case ROTATE: {
                int ang;
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (angle == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing angle argument!");
                    return;
                }
                for (ang = angle.asInt(); ang < 0; ang = 360 + ang) {
                }
                while (ang > 360) {
                    ang -= 360;
                }
                while (ang > 0) {
                    ang -= 90;
                    schematics.get(name.asString().toUpperCase()).rotateOne();
                }
                break;
            }
            case FLIP_X: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipX();
                break;
            }
            case FLIP_Y: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipY();
                break;
            }
            case FLIP_Z: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                schematics.get(name.asString().toUpperCase()).flipZ();
                break;
            }
            case PASTE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                if (location == null) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Missing location argument!");
                    return;
                }
                try {
                    if (delayed != null && delayed.asBoolean()) {
                        schematics.get(name.asString().toUpperCase()).setBlocksDelayed(location, new Runnable(){

                            @Override
                            public void run() {
                                scriptEntry.setFinished(true);
                            }
                        }, noair != null && noair.asBoolean());
                        break;
                    }
                    scriptEntry.setFinished(true);
                    schematics.get(name.asString().toUpperCase()).setBlocks(location, noair != null && noair.asBoolean());
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Exception pasting schematic file " + name.asString() + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
            case SAVE: {
                if (!schematics.containsKey(name.asString().toUpperCase())) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Schematic file " + name.asString() + " is not loaded.");
                    return;
                }
                try {
                    CuboidBlockSet set = schematics.get(name.asString().toUpperCase());
                    String directory = URLDecoder.decode(System.getProperty("user.dir"));
                    File f = new File(directory + "/plugins/Denizen/schematics/" + fname + ".schematic");
                    if (!Utilities.canWriteToFile(f)) {
                        dB.echoError(scriptEntry.getResidingQueue(), "Cannot edit that file!");
                        return;
                    }
                    f.getParentFile().mkdirs();
                    FileOutputStream fs = new FileOutputStream(f);
                    set.saveMCEditFormatToStream(fs);
                    fs.flush();
                    fs.close();
                    break;
                }
                catch (Exception ex) {
                    dB.echoError(scriptEntry.getResidingQueue(), "Error saving schematic file " + fname + ".");
                    dB.echoError(scriptEntry.getResidingQueue(), ex);
                    return;
                }
            }
        }
    }

    public void schematicTags(ReplaceableTagEvent event) {
        if (!event.matches("schematic", "schem")) {
            return;
        }
        String id = event.hasNameContext() ? event.getNameContext().toUpperCase() : null;
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("list")) {
            event.setReplaced(new dList(schematics.keySet()).getAttribute(attribute.fulfill(1)));
        }
        if (id == null) {
            return;
        }
        if (!schematics.containsKey(id)) {
            if (attribute.startsWith("exists")) {
                event.setReplaced(new Element(false).getAttribute(attribute.fulfill(1)));
                return;
            }
            dB.echoError(attribute.getScriptEntry() != null ? attribute.getScriptEntry().getResidingQueue() : null, "Schematic file " + id + " is not loaded.");
            return;
        }
        CuboidBlockSet set = schematics.get(id);
        if (attribute.startsWith("exists")) {
            event.setReplaced(new Element(true).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("height")) {
            event.setReplaced(new Element(set.y_length).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("length")) {
            event.setReplaced(new Element(set.z_height).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("width")) {
            event.setReplaced(new Element(set.x_width).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("block") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation location = dLocation.valueOf(attribute.getContext(1));
            BlockData block = set.blockAt(location.getX(), location.getY(), location.getZ());
            event.setReplaced(new dMaterial(block).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("origin")) {
            event.setReplaced(new dLocation(null, set.center_x, set.center_y, set.center_z).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("blocks")) {
            event.setReplaced(new Element(set.blocks.size()).getAttribute(attribute.fulfill(1)));
            return;
        }
        if (attribute.startsWith("cuboid") && attribute.hasContext(1)) {
            dLocation origin = dLocation.valueOf(attribute.getContext(1));
            event.setReplaced(set.getCuboid(origin).getAttribute(attribute.fulfill(1)));
            return;
        }
    }

    private static enum Type {
        CREATE,
        LOAD,
        UNLOAD,
        ROTATE,
        PASTE,
        SAVE,
        FLIP_X,
        FLIP_Y,
        FLIP_Z;

    }
}

