/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.tags.core;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dPlugin;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.scripts.commands.core.SQLCommand;
import net.aufdemrand.denizen.scripts.commands.server.BossBarCommand;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.CommandScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.inventory.SlotHelper;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.TagRunnable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.SlowWarning;
import net.aufdemrand.denizencore.utilities.javaluator.DoubleEvaluator;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.map.MapCursor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Scoreboard;

public class ServerTags {
    public SlowWarning mathShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'math' instead of 'm' as a root tag.");
    public SlowWarning ternShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'tern' instead of 't' as a root tag.");
    public SlowWarning serverShorthand = new SlowWarning("Short-named tags are hard to read. Please use 'server' instead of 'svr' as a root tag.");

    public ServerTags(Denizen denizen) {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTags.this.mathTag(event);
            }
        }, "math", "m");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTags.this.ternaryTag(event);
            }
        }, "ternary", "tern", "t");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                ServerTags.this.serverTag(event);
            }
        }, "server", "svr", "global");
    }

    public void mathTag(ReplaceableTagEvent event) {
        if (!event.matches("math", "m")) {
            return;
        }
        if (event.matches("m")) {
            this.mathShorthand.warn(event.getScriptEntry());
        }
        try {
            Double evaluation = (Double)new DoubleEvaluator().evaluate(event.getValue());
            event.setReplaced(new Element(String.valueOf(evaluation)).getAttribute(event.getAttributes().fulfill(1)));
        }
        catch (Exception e) {
            dB.echoError("Invalid math tag!");
            event.setReplaced("0.0");
        }
    }

    public void ternaryTag(ReplaceableTagEvent event) {
        if (!event.matches("ternary", "tern", "t")) {
            return;
        }
        if (event.matches("t")) {
            this.ternShorthand.warn(event.getScriptEntry());
        }
        if (!event.hasNameContext()) {
            return;
        }
        if (event.getNameContext().equalsIgnoreCase("true")) {
            event.setReplaced(new Element(event.getValue().trim()).getAttribute(event.getAttributes().fulfill(1)));
        }
    }

    public void serverTag(ReplaceableTagEvent event) {
        block202: {
            BanEntry ban;
            dList players;
            String flag;
            Object npcs;
            String matchInput;
            Object matchPlayer;
            dList plugins;
            Object world;
            String group;
            dList list;
            Object npc;
            String eventName;
            String flag_name;
            Attribute attribute;
            if (!event.matches("server", "svr", "global") || event.replaced()) {
                return;
            }
            if (event.matches("srv")) {
                this.serverShorthand.warn(event.getScriptEntry());
            }
            if (event.matches("global")) {
                dB.echoError(event.getScriptEntry() == null ? null : event.getScriptEntry().getResidingQueue(), "Using 'global' as a base tag is a deprecated alternate name. Please use 'server' instead.");
            }
            if ((attribute = event.getAttributes().fulfill(1)).startsWith("slot_id") && attribute.hasContext(1)) {
                int slotId = SlotHelper.nameToIndex(attribute.getContext(1));
                if (slotId != -1) {
                    event.setReplaced(new Element(slotId).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("list_commands")) {
                dList list2 = new dList();
                for (String string : CommandScriptHelper.knownCommands.keySet()) {
                    list2.add(string);
                }
                event.setReplaced(list2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("scoreboard")) {
                Scoreboard board;
                String name = "main";
                if (attribute.hasContext(1)) {
                    name = attribute.getContext(1);
                    board = ScoreboardHelper.getScoreboard(name);
                } else {
                    board = ScoreboardHelper.getMain();
                }
                if (attribute.startsWith("exists")) {
                    event.setReplaced(new Element(board != null).getAttribute(attribute.fulfill(2)));
                    return;
                }
                if (board == null) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("Scoreboard '" + name + "' does not exist.");
                    }
                    return;
                }
                if (attribute.startsWith("team_members") && attribute.hasContext(2)) {
                    event.setReplacedObject(new dList(board.getEntries()).getObjectAttribute(attribute.fulfill(2)));
                    return;
                }
            }
            if (attribute.startsWith("object_is_valid")) {
                dObject o = ObjectFetcher.pickObjectFor(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new Element(o != null && !(o instanceof Element)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_whitelist")) {
                event.setReplaced(new Element(Bukkit.hasWhitelist()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_flag")) {
                if (!attribute.hasContext(1)) {
                    event.setReplaced("null");
                    return;
                }
                flag_name = attribute.getContext(1);
                event.setReplaced(new Element(FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("flag")) {
                if (!attribute.hasContext(1)) {
                    event.setReplaced("null");
                    return;
                }
                flag_name = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("is_expired") || attribute.startsWith("isexpired")) {
                    event.setReplaced(new Element(!FlagManager.serverHasFlag(flag_name)).getAttribute(attribute.fulfill(1)));
                    return;
                }
                if (attribute.startsWith("size") && !FlagManager.serverHasFlag(flag_name)) {
                    event.setReplaced(new Element(0).getAttribute(attribute.fulfill(1)));
                    return;
                }
                if (FlagManager.serverHasFlag(flag_name)) {
                    FlagManager.Flag flag2 = DenizenAPI.getCurrentInstance().flagManager().getGlobalFlag(flag_name);
                    event.setReplaced(new dList(flag2.toString(), true, flag2.values()).getAttribute(attribute));
                }
                return;
            }
            if (attribute.startsWith("list_biomes")) {
                dList allBiomes = new dList();
                for (Biome biome : Biome.values()) {
                    allBiomes.add(biome.name());
                }
                event.setReplaced(allBiomes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_enchantments")) {
                dList enchants = new dList();
                for (Biome biome : Enchantment.values()) {
                    enchants.add(biome.getName());
                }
                event.setReplaced(enchants.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_entity_types")) {
                dList allEnt = new dList();
                for (Biome biome : EntityType.values()) {
                    allEnt.add(biome.name());
                }
                event.setReplaced(allEnt.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_materials")) {
                dList allMats = new dList();
                for (Biome biome : Material.values()) {
                    allMats.add(biome.name());
                }
                event.setReplaced(allMats.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_sounds")) {
                dList sounds = new dList();
                for (Biome biome : Sound.values()) {
                    sounds.add(biome.toString());
                }
                event.setReplaced(sounds.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_patterns")) {
                dList allPatterns = new dList();
                for (PatternType patternType : PatternType.values()) {
                    allPatterns.add(patternType.toString());
                }
                event.setReplaced(allPatterns.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_potion_effects")) {
                dList statuses = new dList();
                for (PotionEffectType potionEffectType : PotionEffectType.values()) {
                    if (potionEffectType == null) continue;
                    statuses.add(potionEffectType.getName());
                }
                event.setReplaced(statuses.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_potion_types")) {
                dList potionTypes = new dList();
                for (PotionType potionType : PotionType.values()) {
                    potionTypes.add(potionType.toString());
                }
                event.setReplaced(potionTypes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_tree_types")) {
                dList allTrees = new dList();
                for (TreeType treeType : TreeType.values()) {
                    allTrees.add(treeType.name());
                }
                event.setReplaced(allTrees.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_map_cursor_types")) {
                dList mapCursors = new dList();
                for (MapCursor.Type type : MapCursor.Type.values()) {
                    mapCursors.add(type.toString());
                }
                event.setReplaced(mapCursors.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_world_types")) {
                dList worldTypes = new dList();
                for (WorldType worldType : WorldType.values()) {
                    worldTypes.add(worldType.toString());
                }
                event.setReplaced(worldTypes.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_flags")) {
                dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listGlobalFlags());
                dList searchFlags = null;
                if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                    searchFlags = new dList();
                    String string = attribute.getContext(1);
                    if (string.startsWith("regex:")) {
                        try {
                            Pattern pattern = Pattern.compile(string.substring(6), 2);
                            for (String flag3 : allFlags) {
                                if (!pattern.matcher(flag3).matches()) continue;
                                searchFlags.add(flag3);
                            }
                        }
                        catch (Exception e) {
                            dB.echoError(e);
                        }
                    } else {
                        String string2 = CoreUtilities.toLowerCase(string);
                        for (String string3 : allFlags) {
                            if (!CoreUtilities.toLowerCase(string3).contains(string2)) continue;
                            searchFlags.add(string3);
                        }
                    }
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(searchFlags);
                } else {
                    DenizenAPI.getCurrentInstance().flagManager().shrinkGlobalFlags(allFlags);
                }
                event.setReplaced(searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("list_notables")) {
                dList allNotables = new dList();
                if (attribute.hasContext(1)) {
                    String type = CoreUtilities.toLowerCase(attribute.getContext(1));
                    for (Map.Entry<String, Class> typeClass : NotableManager.getReverseClassIdMap().entrySet()) {
                        if (!type.equals(CoreUtilities.toLowerCase(typeClass.getKey()))) continue;
                        for (Object notable : NotableManager.getAllType(typeClass.getValue())) {
                            allNotables.add(((dObject)notable).identify());
                        }
                        break;
                    }
                } else {
                    for (Notable notable : NotableManager.notableObjects.values()) {
                        allNotables.add(((dObject)((Object)notable)).identify());
                    }
                }
                event.setReplaced(allNotables.getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("start_time")) {
                event.setReplaced(new Duration(Denizen.startTime / 50L).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_allocated")) {
                event.setReplaced(new Element(Runtime.getRuntime().totalMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_max")) {
                event.setReplaced(new Element(Runtime.getRuntime().maxMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_free")) {
                event.setReplaced(new Element(Runtime.getRuntime().freeMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("ram_usage")) {
                event.setReplaced(new Element(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().freeMemory()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("available_processors")) {
                event.setReplaced(new Element(Runtime.getRuntime().availableProcessors()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("current_time_millis")) {
                event.setReplaced(new Element(System.currentTimeMillis()).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("has_event") && attribute.hasContext(1)) {
                event.setReplaced(new Element(OldEventManager.eventExists(attribute.getContext(1)) || OldEventManager.eventExists(OldEventManager.StripIdentifiers(attribute.getContext(1)))).getAttribute(attribute.fulfill(1)));
            }
            if (attribute.startsWith("get_event_handlers") && attribute.hasContext(1)) {
                eventName = attribute.getContext(1).toUpperCase();
                List<WorldScriptContainer> EventsOne = OldEventManager.events.get("ON " + eventName);
                List<WorldScriptContainer> list2 = OldEventManager.events.get("ON " + OldEventManager.StripIdentifiers(eventName));
                if (EventsOne == null && list2 == null) {
                    dB.echoError("No world scripts will handle the event '" + eventName + "'");
                } else {
                    dList list3 = new dList();
                    if (EventsOne != null) {
                        Iterator iterator = EventsOne.iterator();
                        while (iterator.hasNext()) {
                            WorldScriptContainer script = (WorldScriptContainer)iterator.next();
                            list3.add("s@" + script.getName());
                        }
                    }
                    if (list2 != null) {
                        for (WorldScriptContainer script : list2) {
                            if (list3.contains("s@" + script.getName())) continue;
                            list3.add("s@" + script.getName());
                        }
                    }
                    event.setReplaced(list3.getAttribute(attribute.fulfill(1)));
                }
            }
            if (attribute.startsWith("selected_npc")) {
                npc = ((Citizens)Bukkit.getPluginManager().getPlugin("Citizens")).getNPCSelector().getSelected((CommandSender)Bukkit.getConsoleSender());
                if (npc == null) {
                    return;
                }
                event.setReplaced(new dNPC((NPC)npc).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("get_npcs_named") && Depends.citizens != null && attribute.hasContext(1)) {
                dList npcs2 = new dList();
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    if (!nPC.getName().equalsIgnoreCase(attribute.getContext(1))) continue;
                    npcs2.add(dNPC.mirrorCitizensNPC(nPC).identify());
                }
                event.setReplaced(npcs2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_file") && attribute.hasContext(1)) {
                File f = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(f)) {
                        if (!attribute.hasAlternative()) {
                            dB.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    dB.echoError(e);
                    return;
                }
                event.setReplaced(new Element(f.exists()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_files") && attribute.hasContext(1)) {
                File folder = new File(DenizenAPI.getCurrentInstance().getDataFolder(), attribute.getContext(1));
                try {
                    if (!Utilities.canReadFile(folder)) {
                        if (!attribute.hasAlternative()) {
                            dB.echoError("Invalid path specified. Invalid paths have been denied by the server administrator.");
                        }
                        return;
                    }
                    if (!folder.exists() || !folder.isDirectory()) {
                        if (!attribute.hasAlternative()) {
                            dB.echoError("Invalid path specified. No directory exists at that path.");
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    dB.echoError(e);
                    return;
                }
                File[] files = folder.listFiles();
                if (files == null) {
                    return;
                }
                dList dList2 = new dList();
                for (File file : files) {
                    dList2.add(file.getName());
                }
                event.setReplaced(dList2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_permissions")) {
                event.setReplaced(new Element(Depends.permissions != null && Depends.permissions.isEnabled()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("has_economy")) {
                event.setReplaced(new Element(Depends.economy != null && Depends.economy.isEnabled()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("denizen_version")) {
                event.setReplaced(new Element(DenizenAPI.getCurrentInstance().getDescription().getVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("bukkit_version")) {
                event.setReplaced(new Element(Bukkit.getBukkitVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("version")) {
                event.setReplaced(new Element(Bukkit.getServer().getVersion()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("java_version")) {
                event.setReplaced(new Element(System.getProperty("java.version")).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("max_players")) {
                event.setReplaced(new Element(Bukkit.getServer().getMaxPlayers()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_sql_connections")) {
                list = new dList();
                for (Map.Entry entry : SQLCommand.connections.entrySet()) {
                    try {
                        if (!((Connection)entry.getValue()).isClosed()) {
                            list.add((String)entry.getKey());
                            continue;
                        }
                        SQLCommand.connections.remove(entry.getKey());
                    }
                    catch (SQLException e) {
                        dB.echoError(attribute.getScriptEntry().getResidingQueue(), e);
                    }
                }
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_prefix")) {
                if (Depends.permissions == null) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    dB.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    world = dWorld.valueOf(attribute.getContext(2));
                    if (world != null) {
                        event.setReplaced(new Element(Depends.chat.getGroupPrefix(((dWorld)world).getWorld(), group)).getAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplaced(new Element(Depends.chat.getGroupPrefix((World)Bukkit.getWorlds().get(0), group)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("group_suffix")) {
                if (Depends.permissions == null) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                group = attribute.getContext(1);
                if (!Arrays.asList(Depends.permissions.getGroups()).contains(group)) {
                    dB.echoError("Invalid group! '" + (group != null ? group : "") + "' could not be found.");
                    return;
                }
                if (attribute.getAttribute(2).startsWith("world")) {
                    world = dWorld.valueOf(attribute.getContext(2));
                    if (world != null) {
                        event.setReplaced(new Element(Depends.chat.getGroupSuffix(((dWorld)world).getWorld(), group)).getAttribute(attribute.fulfill(2)));
                    }
                    return;
                }
                event.setReplaced(new Element(Depends.chat.getGroupSuffix((World)Bukkit.getWorlds().get(0), group)).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_permission_groups")) {
                if (Depends.permissions == null) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    return;
                }
                event.setReplaced(new dList(Arrays.asList(Depends.permissions.getGroups())).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_plugin_names")) {
                plugins = new dList();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(plugin.getName());
                }
                event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_scripts")) {
                dList scripts = new dList();
                for (String string : ScriptRegistry._getScriptNames()) {
                    scripts.add("s@" + string);
                }
                event.setReplaced(scripts.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("match_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (CoreUtilities.toLowerCase(player.getName()).equals(matchInput)) {
                        matchPlayer = player;
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(player.getName()).contains(matchInput) || matchPlayer != null) continue;
                    matchPlayer = player;
                }
                if (matchPlayer != null) {
                    event.setReplaced(new dPlayer((Player)matchPlayer).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("match_offline_player") && attribute.hasContext(1)) {
                matchPlayer = null;
                matchInput = CoreUtilities.toLowerCase(attribute.getContext(1));
                for (Map.Entry<String, UUID> entry : dPlayer.getAllPlayers().entrySet()) {
                    if (CoreUtilities.toLowerCase(entry.getKey()).equals(matchInput)) {
                        matchPlayer = entry.getValue();
                        break;
                    }
                    if (!CoreUtilities.toLowerCase(entry.getKey()).contains(matchInput) || matchPlayer != null) continue;
                    matchPlayer = entry.getValue();
                }
                if (matchPlayer != null) {
                    event.setReplaced(new dPlayer((UUID)matchPlayer).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("get_npcs_assigned") && Depends.citizens != null && attribute.hasContext(1)) {
                dScript script = dScript.valueOf(attribute.getContext(1));
                if (script == null || !(script.getContainer() instanceof AssignmentScriptContainer)) {
                    dB.echoError("Invalid script specified.");
                } else {
                    npcs = new dList();
                    for (NPC npc3 : CitizensAPI.getNPCRegistry()) {
                        if (!npc3.hasTrait(AssignmentTrait.class) || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).hasAssignment() || !((AssignmentTrait)npc3.getTrait(AssignmentTrait.class)).getAssignment().getName().equalsIgnoreCase(script.getName())) continue;
                        ((dList)npcs).add(dNPC.mirrorCitizensNPC(npc3).identify());
                    }
                    event.setReplaced(((dList)npcs).getAttribute(attribute.fulfill(1)));
                    return;
                }
            }
            if (attribute.startsWith("get_online_players_flagged") && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                dList players2 = new dList();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new dPlayer(player), flag).size() <= 0) continue;
                    players2.add(new dPlayer(player).identify());
                }
                event.setReplaced(players2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("get_players_flagged") && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                dList players2 = new dList();
                for (Map.Entry<String, UUID> entry : dPlayer.getAllPlayers().entrySet()) {
                    if (DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(new dPlayer(entry.getValue()), flag).size() <= 0) continue;
                    players2.add(new dPlayer(entry.getValue()).identify());
                }
                event.setReplaced(players2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("get_spawned_npcs_flagged") && Depends.citizens != null && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                npcs = new dList();
                for (NPC npc4 : CitizensAPI.getNPCRegistry()) {
                    dNPC dNPC2 = dNPC.mirrorCitizensNPC(npc4);
                    if (!dNPC2.isSpawned() || !FlagManager.npcHasFlag(dNPC2, flag)) continue;
                    ((dList)npcs).add(dNPC2.identify());
                }
                event.setReplaced(((dList)npcs).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("get_npcs_flagged") && Depends.citizens != null && attribute.hasContext(1)) {
                flag = attribute.getContext(1);
                npcs = new dList();
                for (NPC npc5 : CitizensAPI.getNPCRegistry()) {
                    dNPC dNPC3 = dNPC.mirrorCitizensNPC(npc5);
                    if (!FlagManager.npcHasFlag(dNPC3, flag)) continue;
                    ((dList)npcs).add(dNPC3.identify());
                }
                event.setReplaced(((dList)npcs).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_npcs") && Depends.citizens != null) {
                dList npcs2 = new dList();
                for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                    npcs2.add(dNPC.mirrorCitizensNPC(nPC).identify());
                }
                event.setReplaced(npcs2.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_worlds")) {
                dList worlds = new dList();
                for (World world2 : Bukkit.getWorlds()) {
                    worlds.add(dWorld.mirrorBukkitWorld(world2).identify());
                }
                event.setReplaced(worlds.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_plugins")) {
                plugins = new dList();
                for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                    plugins.add(new dPlugin(plugin).identify());
                }
                event.setReplaced(plugins.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_players")) {
                players = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_online_players")) {
                players = new dList();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_offline_players")) {
                players = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (offlinePlayer.isOnline()) continue;
                    players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_banned_players")) {
                dList banned = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getBannedPlayers()) {
                    banned.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(banned.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_banned_addresses")) {
                list = new dList();
                list.addAll(Bukkit.getIPBans());
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("is_banned") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                if (ban == null) {
                    event.setReplaced(new Element(false).getAttribute(attribute.fulfill(1)));
                } else if (ban.getExpiration() == null) {
                    event.setReplaced(new Element(true).getAttribute(attribute.fulfill(1)));
                } else {
                    event.setReplaced(new Element(ban.getExpiration().after(new Date())).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("ban_info") && attribute.hasContext(1)) {
                ban = Bukkit.getBanList((BanList.Type)BanList.Type.IP).getBanEntry(attribute.getContext(1));
                attribute.fulfill(1);
                if (ban == null || ban.getExpiration() != null && ban.getExpiration().before(new Date())) {
                    return;
                }
                if (attribute.startsWith("expiration") && ban.getExpiration() != null) {
                    event.setReplaced(new Duration(ban.getExpiration().getTime() / 50L).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("reason")) {
                    event.setReplaced(new Element(ban.getReason()).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("created")) {
                    event.setReplaced(new Duration(ban.getCreated().getTime() / 50L).getAttribute(attribute.fulfill(1)));
                } else if (attribute.startsWith("source")) {
                    event.setReplaced(new Element(ban.getSource()).getAttribute(attribute.fulfill(1)));
                }
                return;
            }
            if (attribute.startsWith("list_ops")) {
                players = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_online_ops")) {
                players = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getOperators()) {
                    if (!offlinePlayer.isOnline()) continue;
                    players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("list_offline_ops")) {
                players = new dList();
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.isOp() || offlinePlayer.isOnline()) continue;
                    players.add(dPlayer.mirrorBukkitPlayer(offlinePlayer).identify());
                }
                event.setReplaced(players.getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("motd")) {
                event.setReplaced(new Element(Bukkit.getServer().getMotd()).getAttribute(attribute.fulfill(1)));
                return;
            }
            if (attribute.startsWith("entity_is_spawned") && attribute.hasContext(1)) {
                dEntity ent = dEntity.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new Element(ent != null && ent.isUnique() && ent.isSpawned() ? "true" : "false").getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("player_is_valid") && attribute.hasContext(1)) {
                event.setReplaced(new Element(dPlayer.playerNameIsValid(attribute.getContext(1))).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("npc_is_valid") && attribute.hasContext(1)) {
                npc = dNPC.valueOf(attribute.getContext(1), new BukkitTagContext(null, null, false, null, false, null));
                event.setReplaced(new Element(npc != null && ((dNPC)npc).isValid()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("current_bossbars")) {
                dList dl = new dList();
                for (String string : BossBarCommand.bossBarMap.keySet()) {
                    dl.add(string);
                }
                event.setReplaced(dl.getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("recent_tps")) {
                list = new dList();
                for (Object object : (Object)NMSHandler.getInstance().getRecentTps()) {
                    list.add(new Element((double)object).identify());
                }
                event.setReplaced(list.getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("port")) {
                event.setReplaced(new Element(NMSHandler.getInstance().getPort()).getAttribute(attribute.fulfill(1)));
            } else if (attribute.startsWith("debug_enabled")) {
                event.setReplaced(new Element(dB.showDebug).getAttribute(attribute.fulfill(1)));
            } else if (attribute.matches("list_plugins_handling_event") && attribute.hasContext(1)) {
                eventName = attribute.getContext(1);
                if (eventName.contains(".")) {
                    try {
                        Class<?> clazz = Class.forName(eventName, false, ServerTags.class.getClassLoader());
                        dList dList3 = ServerTags.getHandlerPluginList(clazz);
                        if (dList3 != null) {
                            event.setReplaced(dList3.getAttribute(attribute.fulfill(1)));
                        }
                        break block202;
                    }
                    catch (ClassNotFoundException ex) {
                        if (!attribute.hasAlternative()) {
                            dB.echoError(ex);
                        }
                        break block202;
                    }
                }
                ScriptEvent scriptEvent = ScriptEvent.eventLookup.get(CoreUtilities.toLowerCase(eventName));
                if (scriptEvent instanceof Listener) {
                    Denizen denizen = DenizenAPI.getCurrentInstance();
                    for (Class clazz : denizen.getPluginLoader().createRegisteredListeners((Listener)scriptEvent, (Plugin)denizen).keySet()) {
                        dList result = ServerTags.getHandlerPluginList(clazz);
                        if (result == null || result.size() <= 0) continue;
                        event.setReplaced(result.getAttribute(attribute.fulfill(1)));
                        return;
                    }
                    event.setReplaced(new dList().getAttribute(attribute.fulfill(1)));
                }
            }
        }
    }

    public static dList getHandlerPluginList(Class eventClass) {
        HandlerList handlers;
        if (Event.class.isAssignableFrom(eventClass) && (handlers = BukkitScriptEvent.getEventListeners(eventClass)) != null) {
            dList result = new dList();
            HashSet<String> deduplicationSet = new HashSet<String>();
            for (RegisteredListener listener : handlers.getRegisteredListeners()) {
                if (!deduplicationSet.add(listener.getPlugin().getName())) continue;
                result.addObject(new dPlugin(listener.getPlugin()));
            }
            return result;
        }
        return null;
    }

    public static void adjustServer(Mechanism mechanism) {
        if (mechanism.matches("delete_file") && mechanism.hasValue()) {
            if (!Settings.allowDelete()) {
                dB.echoError("File deletion disabled by administrator.");
                return;
            }
            File file = new File(DenizenAPI.getCurrentInstance().getDataFolder(), mechanism.getValue().asString());
            if (!Utilities.canWriteToFile(file)) {
                dB.echoError("Cannot delete that file (unsafe path).");
                return;
            }
            try {
                if (!file.delete()) {
                    dB.echoError("Failed to delete file: returned false");
                }
            }
            catch (Exception e) {
                dB.echoError("Failed to delete file: " + e.getMessage());
            }
        }
        if (mechanism.matches("redirect_logging") && mechanism.hasValue()) {
            if (!Settings.allowConsoleRedirection()) {
                dB.echoError("Console redirection disabled by administrator.");
                return;
            }
            if (mechanism.getValue().asBoolean()) {
                DenizenCore.logInterceptor.redirectOutput();
            } else {
                DenizenCore.logInterceptor.standardOutput();
            }
        }
        if (mechanism.matches("reset_event_stats")) {
            for (ScriptEvent se : ScriptEvent.events) {
                se.stats.fires = 0L;
                se.stats.scriptFires = 0L;
                se.stats.nanoTimes = 0L;
            }
        }
        if (mechanism.matches("cleanmem")) {
            System.gc();
        }
        if (mechanism.matches("restart")) {
            if (!Settings.allowServerRestart()) {
                dB.echoError("Server restart disabled by administrator. Consider using 'shutdown'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server restarted by a Denizen script, see config to prevent this!");
            Bukkit.spigot().restart();
        }
        if (mechanism.matches("save")) {
            DenizenAPI.getCurrentInstance().saveSaves();
        }
        if (Depends.citizens != null && mechanism.matches("save_citizens")) {
            Depends.citizens.storeNPCs(new CommandContext(new String[0]));
        }
        if (mechanism.matches("shutdown")) {
            if (!Settings.allowServerStop()) {
                dB.echoError("Server stop disabled by administrator. Consider using 'restart'.");
                return;
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "+> Server shutdown by a Denizen script, see config to prevent this!");
            Bukkit.shutdown();
        }
    }
}

