/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.inventory;

import net.aufdemrand.denizen.nms.NMSHandler;
import net.aufdemrand.denizen.utilities.inventory.InventoryMenuItem;
import net.aufdemrand.denizen.utilities.inventory.MenuCloseBehaviour;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryMenu
implements InventoryHolder {
    public static final int ROW_SIZE = 9;
    protected InventoryMenuItem[] items;
    protected Inventory inventory;
    protected String title;
    protected int size;
    protected MenuCloseBehaviour closeBehaviour;

    public InventoryMenu(String title, int rows) {
        this.title = title;
        this.size = rows * 9;
        this.items = new InventoryMenuItem[this.size];
    }

    public void setMenuCloseBehaviour(MenuCloseBehaviour menuCloseBehaviour) {
        this.closeBehaviour = menuCloseBehaviour;
    }

    public MenuCloseBehaviour getMenuCloseBehaviour() {
        return this.closeBehaviour;
    }

    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)this.title);
        }
        return this.inventory;
    }

    public boolean addItem(InventoryMenuItem item, int x, int y) {
        return this.addItem(item, y * 9 + x);
    }

    public boolean addItem(InventoryMenuItem item, int index) {
        ItemStack slot = this.getInventory().getItem(index);
        if (slot != null && slot.getType() != Material.AIR) {
            return false;
        }
        this.getInventory().setItem(index, item.getItemStack());
        this.items[index] = item;
        item.setIndex(index);
        item.addToMenu(this);
        return true;
    }

    public void selectItem(Player player, int index) {
        this.selectItem(player, index, false, false);
    }

    public void selectItem(Player player, int index, boolean right, boolean shift) {
        InventoryMenuItem item = this.items[index];
        if (item != null) {
            item.onClick(player, right, shift);
        }
    }

    public void openMenu(Player player) {
        if (this.getInventory().getViewers().contains(player)) {
            throw new IllegalArgumentException(player.getName() + " is already viewing " + NMSHandler.getInstance().getTitle(this.getInventory()));
        }
        player.openInventory(this.getInventory());
    }

    public void updateMenu() {
        for (HumanEntity entity : this.getInventory().getViewers()) {
            ((Player)entity).updateInventory();
        }
    }

    public void closeMenu(Player player) {
        if (this.getInventory().getViewers().contains(player)) {
            InventoryCloseEvent event = new InventoryCloseEvent(player.getOpenInventory());
            Bukkit.getPluginManager().callEvent((Event)event);
            player.closeInventory();
        }
    }

    protected InventoryMenu clone() {
        InventoryMenu c = new InventoryMenu(this.title, this.size);
        c.setMenuCloseBehaviour(this.closeBehaviour);
        for (int i = 0; i < this.items.length; ++i) {
            this.addItem(this.items[i], i);
        }
        return c;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{title=" + this.title + "; size=" + this.size + "}";
    }
}

