/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.maps;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.stream.FileImageOutputStream;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.maps.DenizenMapRenderer;
import net.aufdemrand.denizen.utilities.maps.MapAnimatedImage;
import net.aufdemrand.denizen.utilities.maps.MapCursor;
import net.aufdemrand.denizen.utilities.maps.MapImage;
import net.aufdemrand.denizen.utilities.maps.MapObject;
import net.aufdemrand.denizen.utilities.maps.MapText;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.NaturalOrderComparator;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class DenizenMapManager {
    private static final Map<Integer, DenizenMapRenderer> mapRenderers = new HashMap<Integer, DenizenMapRenderer>();
    private static final Map<String, String> downloadedByUrl = new HashMap<String, String>();
    private static final File imagesFolder = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "images");
    private static final File imageDownloads = new File(imagesFolder, "downloaded");
    private static final File mapsFile = new File(DenizenAPI.getCurrentInstance().getDataFolder(), "maps.yml");
    private static int downloadCount = (imageDownloads.exists() ? imageDownloads.listFiles().length : 0) + 1;
    private static YamlConfiguration mapsConfig;

    public static void reloadMaps() {
        MapView mapView;
        HashMap<Integer, List<MapRenderer>> oldMapRenderers = new HashMap<Integer, List<MapRenderer>>();
        for (Map.Entry<Integer, DenizenMapRenderer> entry : mapRenderers.entrySet()) {
            DenizenMapRenderer renderer = entry.getValue();
            oldMapRenderers.put(entry.getKey(), renderer.getOldRenderers());
            renderer.deactivate();
        }
        mapRenderers.clear();
        downloadedByUrl.clear();
        mapsConfig = YamlConfiguration.loadConfiguration((File)mapsFile);
        ConfigurationSection mapsSection = mapsConfig.getConfigurationSection("MAPS");
        if (mapsSection == null) {
            return;
        }
        for (String key : mapsSection.getKeys(false)) {
            List oldRenderers;
            int mapId = Integer.valueOf(key);
            mapView = Bukkit.getServer().getMap((int)((short)mapId));
            if (mapView == null) {
                dB.echoError("Map #" + key + " does not exist. Has it been removed? Deleting from maps.yml...");
                mapsSection.set(key, null);
                continue;
            }
            ConfigurationSection objectsData = mapsSection.getConfigurationSection(key + ".objects");
            if (oldMapRenderers.containsKey(mapId)) {
                oldRenderers = (List)oldMapRenderers.get(mapId);
            } else {
                oldRenderers = mapView.getRenderers();
                for (MapRenderer oldRenderer : oldRenderers) {
                    mapView.removeRenderer(oldRenderer);
                }
            }
            DenizenMapRenderer renderer = new DenizenMapRenderer(oldRenderers, mapsSection.getBoolean(key + ".auto update", false));
            renderer.displayOriginal = mapsSection.getBoolean(key + ".original", true);
            ArrayList objects = new ArrayList(objectsData.getKeys(false));
            Collections.sort(objects, new NaturalOrderComparator());
            for (String objectKey : objects) {
                String type = objectsData.getString(objectKey + ".type").toUpperCase();
                String xTag = objectsData.getString(objectKey + ".x");
                String yTag = objectsData.getString(objectKey + ".y");
                String visibilityTag = objectsData.getString(objectKey + ".visibility");
                boolean debug = aH.getBooleanFrom(objectsData.getString(objectKey + ".debug", "false"));
                boolean worldC = aH.getBooleanFrom(objectsData.getString(objectKey + ".world_coordinates", "false"));
                MapObject object = null;
                if (type.equals("CURSOR")) {
                    object = new MapCursor(xTag, yTag, visibilityTag, debug, objectsData.getString(objectKey + ".direction"), objectsData.getString(objectKey + ".cursor"));
                } else if (type.equals("IMAGE")) {
                    String file = objectsData.getString(objectKey + ".image");
                    int width = objectsData.getInt(objectKey + ".width", 0);
                    int height = objectsData.getInt(objectKey + ".height", 0);
                    object = CoreUtilities.toLowerCase(file).endsWith(".gif") ? new MapAnimatedImage(xTag, yTag, visibilityTag, debug, file, width, height) : new MapImage(xTag, yTag, visibilityTag, debug, file, width, height);
                } else if (type.equals("TEXT")) {
                    object = new MapText(xTag, yTag, visibilityTag, debug, objectsData.getString(objectKey + ".text"));
                }
                if (object == null) continue;
                object.worldCoordinates = worldC;
                renderer.addObject(object);
            }
            mapView.addRenderer((MapRenderer)renderer);
            mapRenderers.put(mapId, renderer);
        }
        for (Map.Entry entry : oldMapRenderers.entrySet()) {
            int id = (Integer)entry.getKey();
            if (mapRenderers.containsKey(id) || (mapView = Bukkit.getServer().getMap((int)((short)id))) == null) continue;
            for (MapRenderer renderer : (List)entry.getValue()) {
                mapView.addRenderer(renderer);
            }
        }
        ConfigurationSection configurationSection = mapsConfig.getConfigurationSection("DOWNLOADED");
        if (configurationSection == null) {
            return;
        }
        for (String image : configurationSection.getKeys(false)) {
            downloadedByUrl.put(CoreUtilities.toLowerCase(configurationSection.getString(image)), image.replace("DOT", "."));
        }
    }

    public static void saveMaps() {
        for (Map.Entry<Integer, DenizenMapRenderer> entry : mapRenderers.entrySet()) {
            if (!entry.getValue().isActive()) continue;
            mapsConfig.set("MAPS." + entry.getKey(), entry.getValue().getSaveData());
        }
        for (Map.Entry<Object, Object> entry : downloadedByUrl.entrySet()) {
            mapsConfig.set("DOWNLOADED." + ((String)entry.getValue()).replace(".", "DOT"), entry.getKey());
        }
        try {
            mapsConfig.save(mapsFile);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static void setMap(MapView map, DenizenMapRenderer denizenMapRenderer) {
        List oldRenderers = map.getRenderers();
        for (MapRenderer renderer : oldRenderers) {
            map.removeRenderer(renderer);
        }
        map.addRenderer((MapRenderer)denizenMapRenderer);
        mapRenderers.put(map.getId(), denizenMapRenderer);
    }

    public static DenizenMapRenderer getDenizenRenderer(MapView map) {
        DenizenMapRenderer dmr;
        int mapId = map.getId();
        if (!mapRenderers.containsKey(mapId)) {
            dmr = new DenizenMapRenderer(map.getRenderers(), false);
            DenizenMapManager.setMap(map, dmr);
        } else {
            dmr = mapRenderers.get(mapId);
        }
        return dmr;
    }

    public static List<MapRenderer> removeDenizenRenderers(MapView map) {
        ArrayList<MapRenderer> oldRenderers = new ArrayList<MapRenderer>();
        for (MapRenderer renderer : map.getRenderers()) {
            if (!(renderer instanceof DenizenMapRenderer)) continue;
            map.removeRenderer(renderer);
            oldRenderers.addAll(((DenizenMapRenderer)renderer).getOldRenderers());
            ((DenizenMapRenderer)renderer).deactivate();
            mapRenderers.remove(map.getId());
        }
        return oldRenderers;
    }

    public static String getActualFile(String file) {
        String fileLower = CoreUtilities.toLowerCase(file);
        if (!fileLower.startsWith("http://") && !fileLower.startsWith("https://")) {
            File f = new File(imagesFolder, file);
            if (!Utilities.canReadFile(f)) {
                dB.echoError("Server config denies reading files in that location.");
                return null;
            }
            return f.getPath();
        }
        try {
            return DenizenMapManager.downloadImage(new URL(file));
        }
        catch (MalformedURLException e) {
            dB.echoError("URL is malformed: " + file);
            return null;
        }
    }

    private static String downloadImage(URL url) {
        try {
            int i;
            File image;
            String urlString;
            if (!imageDownloads.exists()) {
                imageDownloads.mkdirs();
            }
            if (downloadedByUrl.containsKey(urlString = CoreUtilities.toLowerCase(url.toString())) && (image = new File(imageDownloads, downloadedByUrl.get(urlString))).exists()) {
                return image.getPath();
            }
            URLConnection connection = url.openConnection();
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            int lastDot = urlString.lastIndexOf(46);
            String fileName = String.format("%0" + (6 - String.valueOf(downloadCount).length()) + "d", downloadCount) + (lastDot > 0 ? urlString.substring(lastDot) : "");
            File output = new File(imageDownloads, fileName);
            FileImageOutputStream out = new FileImageOutputStream(output);
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
            out.close();
            in.close();
            downloadedByUrl.put(urlString, fileName);
            ++downloadCount;
            return output.getPath();
        }
        catch (IOException e) {
            dB.echoError(e);
            return null;
        }
    }
}

