/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events.core;

import java.util.Calendar;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;

public class SystemTimeScriptEvent
extends ScriptEvent {
    public static SystemTimeScriptEvent instance;
    public Element hour;
    public ScriptEntryData data = null;
    public Element minute;
    public long seconds;
    boolean enab = false;
    int lH = 0;
    int lM = 0;
    long lS = 0L;
    boolean minuteChanged = true;

    public SystemTimeScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer script, String event) {
        return event.startsWith("system time");
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return this.data;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        int count;
        String time = path.rawEventArgAt(2);
        String countString = path.switches.get("every");
        int n = count = countString == null ? 1 : aH.getIntegerFrom(countString);
        if (time.equals("secondly")) {
            return this.seconds % (long)count == 0L;
        }
        if (time.equals("minutely")) {
            if (!this.minuteChanged) {
                return false;
            }
            long minutes = this.seconds / 60L;
            return minutes % (long)count == 0L;
        }
        if (time.equals("hourly")) {
            if (!this.minuteChanged || this.lM != 0) {
                return false;
            }
            long hours = this.seconds / 3600L;
            return hours % (long)count == 0L;
        }
        return this.minuteChanged && time.equals(this.hour.asString() + ":" + this.minute.asString());
    }

    @Override
    public String getName() {
        return "SystemTime";
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("hour")) {
            return this.hour;
        }
        if (name.equals("minute")) {
            return this.minute;
        }
        return super.getContext(name);
    }

    @Override
    public void init() {
        this.enab = true;
    }

    @Override
    public void destroy() {
        this.enab = false;
    }

    public void checkTime() {
        if (!this.enab) {
            return;
        }
        this.seconds = System.currentTimeMillis() / 1000L;
        if (this.lS == this.seconds) {
            return;
        }
        this.lS = this.seconds;
        Calendar calendar = Calendar.getInstance();
        int h = calendar.get(11);
        int m = calendar.get(12);
        this.minuteChanged = this.lH != h || this.lM != m;
        this.lH = h;
        this.lM = m;
        this.hour = h < 10 ? new Element("0" + h) : new Element(h);
        this.minute = m < 10 ? new Element("0" + m) : new Element(m);
        this.data = DenizenCore.getImplementation().getEmptyScriptEntryData();
        this.fire();
    }
}

