/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class ItemEnchantedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static ItemEnchantedScriptEvent instance;
    public dEntity entity;
    public dLocation location;
    public dInventory inventory;
    public dItem item;
    public Element button;
    public int cost;
    public EnchantItemEvent event;
    public boolean itemEdited;
    public dItem enchantsRes;

    public ItemEnchantedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("enchanted");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String itemTest = path.eventArgLowerAt(0);
        if (!itemTest.equals("item") && !this.tryItem(this.item, itemTest)) {
            return false;
        }
        return this.runInCheck(path, this.location);
    }

    @Override
    public String getName() {
        return "ItemEnchanted";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesInteger(determination)) {
            this.cost = aH.getIntegerFrom(determination);
            return true;
        }
        if (CoreUtilities.toLowerCase(determination).startsWith("result:")) {
            String ditem = determination.substring("result:".length());
            this.item = dItem.valueOf(ditem, container);
            this.itemEdited = true;
            return true;
        }
        if (CoreUtilities.toLowerCase(determination).startsWith("enchants:")) {
            String ditem = determination.substring("enchants:".length());
            this.enchantsRes = dItem.valueOf(ditem, container);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("entity")) {
            return this.entity;
        }
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("inventory")) {
            return this.inventory;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("button")) {
            return this.button;
        }
        if (name.equals("cost")) {
            return new Element(this.cost);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onItemEnchanted(EnchantItemEvent event) {
        this.entity = new dEntity((Entity)event.getEnchanter());
        this.location = new dLocation(event.getEnchantBlock().getLocation());
        this.inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        this.item = new dItem(event.getItem());
        this.button = new Element(event.whichButton());
        this.cost = event.getExpLevelCost();
        this.itemEdited = false;
        this.event = event;
        this.enchantsRes = null;
        this.fire((Event)event);
        event.setExpLevelCost(this.cost);
        if (this.itemEdited) {
            event.getItem().setItemMeta(this.item.getItemStack().getItemMeta());
        }
        if (this.enchantsRes != null) {
            event.getEnchantsToAdd().clear();
            event.getEnchantsToAdd().putAll(this.enchantsRes.getItemStack().getItemMeta().getEnchants());
        }
    }
}

