/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

public class PlayerTabCompleteScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerTabCompleteScriptEvent instance;
    public TabCompleteEvent event;
    public String buffer;
    public dList completions;
    public CommandSender sender;

    public PlayerTabCompleteScriptEvent() {
        instance = this;
    }

    public String getCommand() {
        String cmd;
        String[] args = this.buffer.trim().split(" ");
        String string = cmd = args.length > 0 ? args[0] : "";
        if (this.sender instanceof Player) {
            cmd = cmd.replaceFirst("/", "");
        }
        return cmd;
    }

    public String getCurrentArg() {
        int i = this.buffer.lastIndexOf(32);
        return i > 0 ? this.buffer.substring(i + 1) : this.getCommand();
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("tab complete");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return true;
    }

    @Override
    public String getName() {
        return "TabComplete";
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.length() > 0 && !PlayerTabCompleteScriptEvent.isDefaultDetermination(determination)) {
            this.completions = dList.valueOf(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.sender instanceof Player ? new dPlayer((Player)this.sender) : null, null);
    }

    @Override
    public dObject getContext(String name) {
        if (name.equals("buffer")) {
            return new Element(this.buffer);
        }
        if (name.equals("command")) {
            return new Element(this.getCommand());
        }
        if (name.equals("current_arg")) {
            return new Element(this.getCurrentArg());
        }
        if (name.equals("completions")) {
            return this.completions;
        }
        if (name.equals("server")) {
            return new Element(this.sender instanceof ConsoleCommandSender);
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        this.buffer = event.getBuffer();
        this.completions = new dList(event.getCompletions());
        this.sender = event.getSender();
        this.event = event;
        this.fire((Event)event);
        event.setCompletions((List)this.completions);
    }
}

