/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;

public class EntityInfected
implements Property {
    public static final String[] handledTags = new String[]{"is_infected"};
    public static final String[] handledMechs = new String[]{"is_infected"};
    dEntity infected;

    public static boolean describes(dObject entity) {
        if (!(entity instanceof dEntity)) {
            return false;
        }
        return ((dEntity)entity).getBukkitEntityType() == EntityType.ZOMBIE || ((dEntity)entity).getBukkitEntityType() == EntityType.VILLAGER;
    }

    public static EntityInfected getFrom(dObject entity) {
        if (!EntityInfected.describes(entity)) {
            return null;
        }
        return new EntityInfected((dEntity)entity);
    }

    private EntityInfected(dEntity item) {
        this.infected = item;
    }

    public boolean isInfected() {
        return this.infected.getBukkitEntity() instanceof Zombie && this.infected.getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER;
    }

    public void setInfected(boolean bool) {
        if (bool) {
            if (this.infected.isCitizensNPC()) {
                NPC infected_npc = this.infected.getDenizenNPC().getCitizen();
                infected_npc.setBukkitEntityType(EntityType.ZOMBIE_VILLAGER);
            }
            LivingEntity entity = this.infected.getLivingEntity();
            ZombieVillager infect = (ZombieVillager)entity.getLocation().getWorld().spawnEntity((Location)this.infected.getLocation(), EntityType.ZOMBIE_VILLAGER);
            infect.setHealth(entity.getHealth());
            infect.getEquipment().setArmorContents(entity.getEquipment().getArmorContents());
            entity.remove();
            this.infected.setEntity((Entity)infect);
        }
    }

    @Override
    public String getPropertyString() {
        if (this.isInfected()) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "infected";
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_infected")) {
            dB.echoError("Different infection types are represented by different entity types. Please remove usage of the 'is_infected' tag.");
            return new Element(this.isInfected()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("is_infected") && mechanism.requireBoolean()) {
            dB.echoError("Different infection types are represented by different entity types. Please remove usage of the 'is_infected' mechanism.");
            this.setInfected(mechanism.getValue().asBoolean());
        }
    }
}

