/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.item;

import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemChargedProjectile
implements Property {
    public static final String[] handledTags = new String[]{"charged_projectiles", "is_charged"};
    public static final String[] handledMechs = new String[]{"charged_projectiles", "add_charged_projectile", "remove_charged_projectiles"};
    dItem item;

    public static boolean describes(dObject item) {
        return item instanceof dItem && ((dItem)item).getItemStack().getType() == Material.CROSSBOW;
    }

    public static ItemChargedProjectile getFrom(dObject item) {
        if (!ItemChargedProjectile.describes(item)) {
            return null;
        }
        return new ItemChargedProjectile((dItem)item);
    }

    private ItemChargedProjectile(dItem _item) {
        this.item = _item;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("charged_projectiles")) {
            return this.getChargedProjectiles().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_charged")) {
            return new Element(((CrossbowMeta)this.item.getItemStack().getItemMeta()).hasChargedProjectiles()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public dList getChargedProjectiles() {
        CrossbowMeta meta = (CrossbowMeta)this.item.getItemStack().getItemMeta();
        dList list = new dList();
        if (!meta.hasChargedProjectiles()) {
            return list;
        }
        for (ItemStack projectile : meta.getChargedProjectiles()) {
            list.addObject(new dItem(projectile));
        }
        return list;
    }

    @Override
    public String getPropertyString() {
        dList projectiles = this.getChargedProjectiles();
        return projectiles.size() > 0 ? projectiles.identify() : null;
    }

    @Override
    public String getPropertyId() {
        return "charged_projectiles";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CrossbowMeta meta;
        if (mechanism.matches("charged_projectiles")) {
            meta = (CrossbowMeta)this.item.getItemStack().getItemMeta();
            meta.setChargedProjectiles(null);
            for (dItem projectile : mechanism.valueAsType(dList.class).filter(dItem.class, mechanism.context)) {
                try {
                    meta.addChargedProjectile(projectile.getItemStack());
                }
                catch (IllegalArgumentException e) {
                    dB.echoError("Charged crossbow projectiles may only be arrows or fireworks!");
                }
            }
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("add_charged_projectile") && mechanism.requireObject(dItem.class)) {
            meta = (CrossbowMeta)this.item.getItemStack().getItemMeta();
            try {
                meta.addChargedProjectile(mechanism.valueAsType(dItem.class).getItemStack());
            }
            catch (IllegalArgumentException e) {
                dB.echoError("Charged crossbow projectiles may only be arrows or fireworks!");
            }
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
        if (mechanism.matches("remove_charged_projectiles")) {
            meta = (CrossbowMeta)this.item.getItemStack().getItemMeta();
            meta.setChargedProjectiles(null);
            this.item.getItemStack().setItemMeta((ItemMeta)meta);
        }
    }
}

