/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.material;

import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.block.data.Levelled;

public class MaterialLevel
implements Property {
    public static final String[] handledTags = new String[]{"maximum_level", "level"};
    public static final String[] handledMechs = new String[]{"level"};
    dMaterial material;

    public static boolean describes(dObject material) {
        return material instanceof dMaterial && ((dMaterial)material).hasModernData() && ((dMaterial)material).getModernData().data instanceof Levelled;
    }

    public static MaterialLevel getFrom(dObject _material) {
        if (!MaterialLevel.describes(_material)) {
            return null;
        }
        return new MaterialLevel((dMaterial)_material);
    }

    private MaterialLevel(dMaterial _material) {
        this.material = _material;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("maximum_level")) {
            return new Element(this.getMax()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("level")) {
            return new Element(this.getCurrent()).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public Levelled getLevelled() {
        return (Levelled)this.material.getModernData().data;
    }

    public int getCurrent() {
        return this.getLevelled().getLevel();
    }

    public int getMax() {
        return this.getLevelled().getMaximumLevel();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "level";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            int level = mechanism.getValue().asInt();
            if (level < 0 || level > this.getMax()) {
                dB.echoError("Level value '" + level + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + this.material.realName() + "'.");
                return;
            }
            this.getLevelled().setLevel(level);
        }
    }
}

